/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2;

import com.labijie.infra.oauth2.AuthenticationCheckingContext;
import com.labijie.infra.oauth2.DefaultAuthenticationProvider$WhenMappings;
import com.labijie.infra.oauth2.DefaultUserService;
import com.labijie.infra.oauth2.ITwoFactorUserDetails;
import com.labijie.infra.oauth2.SignInResult;
import com.labijie.infra.oauth2.events.UserSignedInEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J&\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/labijie/infra/oauth2/DefaultAuthenticationProvider;", "Lorg/springframework/security/authentication/dao/DaoAuthenticationProvider;", "Lorg/springframework/core/Ordered;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "svc", "Lcom/labijie/infra/oauth2/DefaultUserService;", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "(Lorg/springframework/context/ApplicationEventPublisher;Lcom/labijie/infra/oauth2/DefaultUserService;Lorg/springframework/security/crypto/password/PasswordEncoder;)V", "additionalAuthenticationChecks", "", "userDetails", "Lorg/springframework/security/core/userdetails/UserDetails;", "authentication", "Lorg/springframework/security/authentication/UsernamePasswordAuthenticationToken;", "createSuccessAuthentication", "Lorg/springframework/security/core/Authentication;", "principal", "", "user", "getOrder", "", "setTwoFactorGranted", "Lcom/labijie/infra/oauth2/ITwoFactorUserDetails;", "granted", "", "Companion", "oauth2-starter"})
public final class DefaultAuthenticationProvider
extends DaoAuthenticationProvider
implements Ordered {
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private static final Logger slf4jLogger;
    public static final Companion Companion;

    public int getOrder() {
        return -1;
    }

    protected void additionalAuthenticationChecks(@NotNull UserDetails userDetails, @NotNull UsernamePasswordAuthenticationToken authentication) {
        Intrinsics.checkNotNullParameter((Object)userDetails, (String)"userDetails");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        UserDetailsService userDetailsService = this.getUserDetailsService();
        if (userDetailsService == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.labijie.infra.oauth2.DefaultUserService");
        }
        DefaultUserService userSvc = (DefaultUserService)userDetailsService;
        if (!userSvc.getCustomPasswordChecks()) {
            super.additionalAuthenticationChecks(userDetails, authentication);
        }
        ITwoFactorUserDetails twoFactorUserDetails = (ITwoFactorUserDetails)userDetails;
        PasswordEncoder passwordEncoder = this.getPasswordEncoder();
        Intrinsics.checkNotNull((Object)passwordEncoder);
        AuthenticationCheckingContext context = new AuthenticationCheckingContext(twoFactorUserDetails, authentication, passwordEncoder);
        SignInResult result = userSvc.additionalAuthenticationChecks(context);
        switch (DefaultAuthenticationProvider$WhenMappings.$EnumSwitchMapping$0[result.getType().ordinal()]) {
            case 1: {
                throw (Throwable)new BadCredentialsException(result.getErrorCode());
            }
            case 2: {
                this.setTwoFactorGranted(authentication, twoFactorUserDetails, true);
                break;
            }
            case 3: {
                if (!twoFactorUserDetails.isTwoFactorEnabled()) {
                    slf4jLogger.warn("Got SignInResultType.TwoFactorRequired as the result of IIdentityService.authenticationChecks method, but two factor disabled on user details.");
                }
                this.setTwoFactorGranted(authentication, twoFactorUserDetails, false);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setTwoFactorGranted(UsernamePasswordAuthenticationToken authentication, ITwoFactorUserDetails user, boolean granted) {
        Map<String, String> attachedFields;
        Map map;
        Object object = authentication.getDetails();
        if (!TypeIntrinsics.isMutableMap((Object)object)) {
            object = null;
        }
        if ((map = (Map)object) == null) {
            boolean bl = false;
            map = new LinkedHashMap();
        }
        Map map2 = map;
        Map<String, String> $this$forEach$iv = attachedFields = user.getAttachedTokenFields();
        boolean $i$f$forEach = false;
        Map<String, String> map3 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            void k;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$k$v;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$k$v;
            bl3 = false;
            String v = entry.getValue();
            map2.put("__att_" + (String)k, v);
        }
        map2.put("two_factor_granted", granted);
        map2.put("user_id", user.getUserId());
        authentication.setDetails((Object)map2);
    }

    @NotNull
    protected Authentication createSuccessAuthentication(@Nullable Object principal, @Nullable Authentication authentication, @Nullable UserDetails user) {
        Authentication r;
        Authentication authentication2 = r = super.createSuccessAuthentication(principal, authentication, user);
        Intrinsics.checkNotNullExpressionValue((Object)authentication2, (String)"r");
        UserSignedInEvent event = new UserSignedInEvent((Object)this, authentication2);
        this.eventPublisher.publishEvent((ApplicationEvent)event);
        return r;
    }

    public DefaultAuthenticationProvider(@NotNull ApplicationEventPublisher eventPublisher, @NotNull DefaultUserService svc, @NotNull PasswordEncoder passwordEncoder) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)svc, (String)"svc");
        Intrinsics.checkNotNullParameter((Object)passwordEncoder, (String)"passwordEncoder");
        this.eventPublisher = eventPublisher;
        this.setUserDetailsService(svc);
        this.setPasswordEncoder(passwordEncoder);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(DefaultAuthenticationProvider.class);
        Intrinsics.checkNotNull((Object)logger);
        slf4jLogger = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/labijie/infra/oauth2/DefaultAuthenticationProvider$Companion;", "", "()V", "slf4jLogger", "Lorg/slf4j/Logger;", "getSlf4jLogger", "()Lorg/slf4j/Logger;", "oauth2-starter"})
    public static final class Companion {
        @NotNull
        public final Logger getSlf4jLogger() {
            return slf4jLogger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

