/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2;

import com.labijie.infra.oauth2.AuthenticationCheckingContext;
import com.labijie.infra.oauth2.IIdentityService;
import com.labijie.infra.oauth2.SignInResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/labijie/infra/oauth2/DefaultUserService;", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "identityService", "Lcom/labijie/infra/oauth2/IIdentityService;", "(Lcom/labijie/infra/oauth2/IIdentityService;)V", "customPasswordChecks", "", "getCustomPasswordChecks", "()Z", "additionalAuthenticationChecks", "Lcom/labijie/infra/oauth2/SignInResult;", "context", "Lcom/labijie/infra/oauth2/AuthenticationCheckingContext;", "loadUserByUsername", "Lorg/springframework/security/core/userdetails/UserDetails;", "username", "", "oauth2-starter"})
public final class DefaultUserService
implements UserDetailsService {
    private final IIdentityService identityService;

    public final boolean getCustomPasswordChecks() {
        return this.identityService.getCustomPasswordChecks();
    }

    @NotNull
    public UserDetails loadUserByUsername(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return this.identityService.getUserByName(username);
    }

    @NotNull
    public final SignInResult additionalAuthenticationChecks(@NotNull AuthenticationCheckingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.identityService.authenticationChecks(context);
    }

    public DefaultUserService(@NotNull IIdentityService identityService) {
        Intrinsics.checkNotNullParameter((Object)identityService, (String)"identityService");
        this.identityService = identityService;
    }
}

