/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2;

import com.labijie.infra.oauth2.TwoFactorPrincipal;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\nJ\u0015\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/labijie/infra/oauth2/OAuth2Utils;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "currentTwoFactorPrincipal", "Lcom/labijie/infra/oauth2/TwoFactorPrincipal;", "extractClientIdAndSecretFromHeader", "Lkotlin/Pair;", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "extractClientIdAndSecretFromHeaderValue", "header", "getTwoFactorPrincipal", "authentication", "Lorg/springframework/security/core/Authentication;", "getTwoFactorPrincipal$oauth2_starter", "oauth2-starter"})
public final class OAuth2Utils {
    private static final Logger log;
    public static final OAuth2Utils INSTANCE;

    @NotNull
    public final TwoFactorPrincipal currentTwoFactorPrincipal() throws BadCredentialsException {
        SecurityContext context;
        SecurityContext securityContext = context = SecurityContextHolder.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)securityContext, (String)"context");
        Authentication authentication = securityContext.getAuthentication();
        Intrinsics.checkNotNullExpressionValue((Object)authentication, (String)"context.authentication");
        return this.getTwoFactorPrincipal$oauth2_starter(authentication);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TwoFactorPrincipal getTwoFactorPrincipal$oauth2_starter(@NotNull Authentication authentication) throws BadCredentialsException {
        void $this$filterTo$iv$iv;
        Authentication userAuthentication;
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        Authentication authentication2 = userAuthentication = authentication instanceof OAuth2Authentication ? ((OAuth2Authentication)authentication).getUserAuthentication() : authentication;
        Intrinsics.checkNotNullExpressionValue((Object)authentication2, (String)"userAuthentication");
        Object object = authentication2.getDetails();
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map = (Map)object;
        if (map == null) {
            throw (Throwable)new BadCredentialsException("Current authentication dose not contains any user details");
        }
        Map map2 = map;
        boolean bl = false;
        Map attachments = new LinkedHashMap();
        Map $this$filter$iv = map2;
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var10_15 = $this$filterTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var10_15.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry kv = element$iv$iv = iterator.next();
            boolean bl3 = false;
            if (!(kv.getKey() != null && StringsKt.startsWith$default((String)String.valueOf(kv.getKey()), (String)"__att_", (boolean)false, (int)2, null) && kv.getValue() != null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv;
        boolean bl4 = false;
        Iterator iterator2 = object2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl5 = false;
            String key = StringsKt.removePrefix((String)String.valueOf(it.getKey()), (CharSequence)"__att_");
            CharSequence charSequence = key;
            boolean bl6 = false;
            if (!(!StringsKt.isBlank((CharSequence)charSequence)) || it.getValue() == null) continue;
            attachments.put(key, String.valueOf(it.getValue()));
        }
        Object object3 = map2;
        String string = "user_id";
        object2 = "";
        bl4 = false;
        Map map3 = object3;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        String string2 = String.valueOf(map3.getOrDefault(string, object2));
        String string3 = userAuthentication.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"userAuthentication.name");
        object3 = map2;
        string = "two_factor_granted";
        object2 = "false";
        bl4 = false;
        Map map4 = object3;
        if (map4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        object3 = String.valueOf(map4.getOrDefault(string, object2));
        boolean bl7 = false;
        boolean bl8 = Boolean.parseBoolean((String)object3);
        Collection collection = userAuthentication.getAuthorities();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"userAuthentication.authorities");
        return new TwoFactorPrincipal(string2, string3, bl8, collection, attachments);
    }

    @NotNull
    public final Pair<String, String> extractClientIdAndSecretFromHeader(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getHeader("Authorization");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String header = string2;
        return this.extractClientIdAndSecretFromHeaderValue(header);
    }

    @NotNull
    public final Pair<String, String> extractClientIdAndSecretFromHeaderValue(@NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        String string = header;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.startsWith$default((String)string2, (String)"basic ", (boolean)false, (int)2, null)) {
            log.warn("Cant find basic authorization header while grant type was 'password'");
            return new Pair((Object)"", (Object)"");
        }
        String string3 = header;
        int n = 6;
        boolean bl2 = false;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        string3 = string4;
        Object object = "UTF-8";
        bl2 = false;
        Charset charset = Charset.forName((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
        object = charset;
        bl2 = false;
        String string5 = string3;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string5.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] base64Token = byArray;
        byte[] decoded = null;
        try {
            byte[] byArray2 = Base64.getDecoder().decode(base64Token);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Base64.getDecoder().decode(base64Token)");
            decoded = byArray2;
        }
        catch (IllegalArgumentException e) {
            log.warn("Failed to decode basic authentication token while grant type was 'password");
            return new Pair((Object)"", (Object)"");
        }
        Charset charset2 = Charsets.UTF_8;
        boolean bl3 = false;
        String token = new String(decoded, charset2);
        int delim = StringsKt.indexOf$default((CharSequence)token, (String)":", (int)0, (boolean)false, (int)6, null);
        if (delim == -1) {
            log.warn("Failed to decode basic authentication token while grant type was 'password");
            return new Pair((Object)"", (Object)"");
        }
        List strings = StringsKt.split$default((CharSequence)token, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        Collection collection = strings;
        boolean bl4 = false;
        if (collection.size() == 1) {
            return new Pair(CollectionsKt.first((List)strings), (Object)"");
        }
        collection = strings;
        bl4 = false;
        if (collection.size() == 2) {
            return new Pair(CollectionsKt.first((List)strings), CollectionsKt.last((List)strings));
        }
        log.warn("Failed to decode basic authentication token while grant type was 'password");
        return new Pair((Object)"", (Object)"");
    }

    private OAuth2Utils() {
    }

    static {
        OAuth2Utils oAuth2Utils;
        INSTANCE = oAuth2Utils = new OAuth2Utils();
        log = LoggerFactory.getLogger(OAuth2Utils.class);
    }
}

