/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.Base64Utils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lcom/labijie/infra/oauth2/RsaUtils;", "", "()V", "getPrivateKey", "Ljava/security/PrivateKey;", "key", "", "getPublicKey", "Ljava/security/PublicKey;", "oauth2-starter"})
public final class RsaUtils {
    public static final RsaUtils INSTANCE;

    @NotNull
    public final PublicKey getPublicKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = Base64Utils.decodeFromString((String)key);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64Utils.decodeFromString(key)");
        byte[] keyBytes = byArray;
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyFactory.generatePublic(keySpec)");
        return publicKey;
    }

    @NotNull
    public final PrivateKey getPrivateKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = Base64Utils.decodeFromString((String)key);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64Utils.decodeFromString(key)");
        byte[] keyBytes = byArray;
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyFactory.generatePrivate(keySpec)");
        return privateKey;
    }

    private RsaUtils() {
    }

    static {
        RsaUtils rsaUtils;
        INSTANCE = rsaUtils = new RsaUtils();
    }
}

