/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2;

import com.labijie.infra.oauth2.ExtensionMethodsKt;
import com.labijie.infra.oauth2.GrantedAuthorityObject;
import com.labijie.infra.oauth2.ITwoFactorUserDetails;
import com.labijie.infra.oauth2.SimpleTwoFactorUserDetails;
import com.labijie.infra.oauth2.TwoFactorPrincipal;
import com.labijie.infra.oauth2.events.UserSignedInEvent;
import com.labijie.infra.oauth2.token.TwoFactorAuthenticationConverter;
import com.labijie.infra.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014Jh\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u00122\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001dJc\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\fJ\u0012\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0006\u0010#\u001a\u00020$J\u0012\u0010#\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/labijie/infra/oauth2/TwoFactorSignInHelper;", "", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clientDetailsService", "Lorg/springframework/security/oauth2/provider/ClientDetailsService;", "oauth2RequestFactory", "Lorg/springframework/security/oauth2/provider/OAuth2RequestFactory;", "tokenServices", "Lorg/springframework/security/oauth2/provider/token/AuthorizationServerTokenServices;", "(Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/security/oauth2/provider/ClientDetailsService;Lorg/springframework/security/oauth2/provider/OAuth2RequestFactory;Lorg/springframework/security/oauth2/provider/token/AuthorizationServerTokenServices;)V", "signIn", "Lorg/springframework/security/oauth2/common/OAuth2AccessToken;", "clientId", "", "user", "Lcom/labijie/infra/oauth2/ITwoFactorUserDetails;", "twoFactorGranted", "", "scopes", "", "userId", "userName", "twoFactorEnabled", "authorities", "", "Lorg/springframework/security/core/GrantedAuthority;", "scope", "attachedFields", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Iterable;Ljava/lang/Boolean;Ljava/util/Set;Ljava/util/Map;)Lorg/springframework/security/oauth2/common/OAuth2AccessToken;", "signInTwoFactor", "signInTwoFactorCore", "auth", "Lorg/springframework/security/oauth2/provider/OAuth2Authentication;", "signOut", "", "oauth2-starter"})
public final class TwoFactorSignInHelper {
    private final ApplicationEventPublisher eventPublisher;
    private final ClientDetailsService clientDetailsService;
    private final OAuth2RequestFactory oauth2RequestFactory;
    private final AuthorizationServerTokenServices tokenServices;

    @NotNull
    public final OAuth2AccessToken signIn(@NotNull String clientId, @NotNull ITwoFactorUserDetails user, boolean twoFactorGranted, @NotNull Set<String> scopes) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        if (!user.isTwoFactorEnabled() && twoFactorGranted) {
            throw (Throwable)new IllegalArgumentException("SignIn user isTwoFactorEnabled = false, but twoFactorGranted be set to true.");
        }
        String string = user.getUserId();
        String string2 = user.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"user.username");
        boolean bl = user.isTwoFactorEnabled();
        Collection collection = user.getAuthorities();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"user.authorities");
        return this.signIn(clientId, string, string2, twoFactorGranted, bl, collection, scopes, user.getAttachedTokenFields());
    }

    public static /* synthetic */ OAuth2AccessToken signIn$default(TwoFactorSignInHelper twoFactorSignInHelper, String string, ITwoFactorUserDetails iTwoFactorUserDetails, boolean bl, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            boolean bl2 = false;
            set = SetsKt.emptySet();
        }
        return twoFactorSignInHelper.signIn(string, iTwoFactorUserDetails, bl, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OAuth2AccessToken signIn(@NotNull String clientId, @NotNull String userId, @NotNull String userName, boolean twoFactorGranted, boolean twoFactorEnabled, @NotNull Iterable<? extends GrantedAuthority> authorities, @NotNull Set<String> scope, @NotNull Map<String, String> attachedFields) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        Intrinsics.checkNotNullParameter(attachedFields, (String)"attachedFields");
        Iterable<? extends GrantedAuthority> iterable = authorities;
        String string = userName;
        String string2 = userId;
        String string3 = clientId;
        TwoFactorSignInHelper twoFactorSignInHelper = this;
        boolean $i$f$map = false;
        void var11_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GrantedAuthority grantedAuthority = (GrantedAuthority)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string4 = it.getAuthority();
            collection.add(string4);
        }
        collection = (List)destination$iv$iv;
        return twoFactorSignInHelper.signIn(string3, string2, string, (Iterable<String>)collection, twoFactorEnabled ? Boolean.valueOf(twoFactorGranted) : null, scope, attachedFields);
    }

    public static /* synthetic */ OAuth2AccessToken signIn$default(TwoFactorSignInHelper twoFactorSignInHelper, String string, String string2, String string3, boolean bl, boolean bl2, Iterable iterable, Set set, Map map, int n, Object object) {
        boolean bl3;
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
            iterable = SetsKt.emptySet();
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
            set = SetsKt.emptySet();
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
            map = MapsKt.emptyMap();
        }
        return twoFactorSignInHelper.signIn(string, string2, string3, bl, bl2, iterable, set, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OAuth2AccessToken signIn(@NotNull String clientId, @NotNull String userId, @NotNull String userName, @NotNull Iterable<String> authorities, @Nullable Boolean twoFactorGranted, @NotNull Set<String> scope, @NotNull Map<String, String> attachedFields) {
        Collection<GrantedAuthorityObject> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        Intrinsics.checkNotNullParameter(attachedFields, (String)"attachedFields");
        Iterable<String> $this$map$iv = authorities;
        boolean $i$f$map = false;
        Iterable<String> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            GrantedAuthorityObject grantedAuthorityObject = new GrantedAuthorityObject((String)it);
            collection.add(grantedAuthorityObject);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        ArrayList authorityObjects = new ArrayList(collection2);
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
        SimpleTwoFactorUserDetails user = new SimpleTwoFactorUserDetails(userId, userName, false, false, null, false, false, twoFactorGranted != null, authorityObjects, attachedFields, 124, null);
        destination$iv$iv = new AuthorizationRequest(clientId, (Collection)scope);
        $i$f$mapTo = false;
        boolean bl = false;
        Collection $this$apply = destination$iv$iv;
        boolean $i$a$-apply-TwoFactorSignInHelper$signIn$request$22 = false;
        $this$apply.setAuthorities(authorityObjects);
        Collection request = destination$iv$iv;
        TokenRequest tokenRequest = this.oauth2RequestFactory.createTokenRequest((AuthorizationRequest)request, "password");
        OAuth2Request oauth2Request = this.oauth2RequestFactory.createOAuth2Request(client, tokenRequest);
        $this$apply = new UsernamePasswordAuthenticationToken((Object)user, (Object)"", (Collection)authorityObjects);
        $i$a$-apply-TwoFactorSignInHelper$signIn$request$22 = false;
        boolean bl2 = false;
        Collection $this$apply2 = $this$apply;
        boolean bl3 = false;
        boolean bl4 = false;
        Map map = new LinkedHashMap();
        TwoFactorAuthenticationConverter.setUserDetails$default(TwoFactorAuthenticationConverter.INSTANCE, map, user, null, 4, null);
        $this$apply2.setDetails(map);
        Collection userAuthentication = $this$apply;
        OAuth2Authentication $i$a$-apply-TwoFactorSignInHelper$signIn$request$22 = new OAuth2Authentication(oauth2Request, (Authentication)userAuthentication);
        bl2 = false;
        boolean bl5 = false;
        OAuth2Authentication $this$apply3 = $i$a$-apply-TwoFactorSignInHelper$signIn$request$22;
        boolean bl6 = false;
        $this$apply3.setAuthenticated(true);
        OAuth2Authentication authentication = $i$a$-apply-TwoFactorSignInHelper$signIn$request$22;
        OAuth2AccessToken token = this.tokenServices.createAccessToken(authentication);
        this.eventPublisher.publishEvent((ApplicationEvent)new UserSignedInEvent(this, (Authentication)authentication));
        OAuth2AccessToken oAuth2AccessToken = token;
        Intrinsics.checkNotNullExpressionValue((Object)oAuth2AccessToken, (String)"token");
        return oAuth2AccessToken;
    }

    public static /* synthetic */ OAuth2AccessToken signIn$default(TwoFactorSignInHelper twoFactorSignInHelper, String string, String string2, String string3, Iterable iterable, Boolean bl, Set set, Map map, int n, Object object) {
        boolean bl2;
        if ((n & 0x10) != 0) {
            bl = null;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
            set = SetsKt.emptySet();
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
            map = MapsKt.emptyMap();
        }
        return twoFactorSignInHelper.signIn(string, string2, string3, iterable, bl, set, map);
    }

    @NotNull
    public final OAuth2AccessToken signInTwoFactor() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        Authentication authentication = securityContext.getAuthentication();
        if (!(authentication instanceof OAuth2Authentication)) {
            authentication = null;
        }
        OAuth2Authentication auth = (OAuth2Authentication)authentication;
        return this.signInTwoFactorCore(auth);
    }

    private final OAuth2AccessToken signInTwoFactorCore(OAuth2Authentication auth) {
        if (auth == null) {
            throw (Throwable)new BadCredentialsException("Current authentication is not authenticated.");
        }
        TwoFactorPrincipal principal = ExtensionMethodsKt.getTwoFactorPrincipal((Authentication)auth);
        if (auth.isAuthenticated()) {
            Authentication authentication = auth.getUserAuthentication();
            Intrinsics.checkNotNullExpressionValue((Object)authentication, (String)"auth.userAuthentication");
            String userName = authentication.getName();
            OAuth2Request oAuth2Request = auth.getOAuth2Request();
            Intrinsics.checkNotNullExpressionValue((Object)oAuth2Request, (String)"auth.oAuth2Request");
            String clientId = oAuth2Request.getClientId();
            OAuth2Request oAuth2Request2 = auth.getOAuth2Request();
            Intrinsics.checkNotNullExpressionValue((Object)oAuth2Request2, (String)"auth.oAuth2Request");
            Set scope = oAuth2Request2.getScope();
            String userId = principal.getUserId();
            this.signOut();
            String string = clientId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clientId");
            String string2 = userName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"userName");
            Collection collection = auth.getAuthorities();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"auth.authorities");
            Iterable iterable = collection;
            Set set = scope;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"scope");
            return TwoFactorSignInHelper.signIn$default(this, string, userId, string2, true, true, iterable, set, null, 128, null);
        }
        throw (Throwable)new BadCredentialsException("bad oauth2 authentication.");
    }

    private final void signOut(OAuth2Authentication auth) {
        if (auth != null) {
            OAuth2AuthenticationDetails detail;
            Object object = auth.getDetails();
            if (!(object instanceof OAuth2AuthenticationDetails)) {
                object = null;
            }
            if ((detail = (OAuth2AuthenticationDetails)object) != null) {
                DefaultTokenServices service;
                AuthorizationServerTokenServices authorizationServerTokenServices = this.tokenServices;
                if (!(authorizationServerTokenServices instanceof DefaultTokenServices)) {
                    authorizationServerTokenServices = null;
                }
                DefaultTokenServices defaultTokenServices = service = (DefaultTokenServices)authorizationServerTokenServices;
                if (defaultTokenServices != null) {
                    defaultTokenServices.revokeToken(detail.getTokenValue());
                }
            }
        } else {
            ExtensionsKt.getLogger((Object)this).warn("Current token was not an oauth2 authentication token, Sign out was unsupported.");
        }
    }

    public final void signOut() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        Authentication authentication = securityContext.getAuthentication();
        if (!(authentication instanceof OAuth2Authentication)) {
            authentication = null;
        }
        OAuth2Authentication auth = (OAuth2Authentication)authentication;
        this.signOut(auth);
    }

    public TwoFactorSignInHelper(@NotNull ApplicationEventPublisher eventPublisher, @NotNull ClientDetailsService clientDetailsService, @NotNull OAuth2RequestFactory oauth2RequestFactory, @NotNull AuthorizationServerTokenServices tokenServices) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)clientDetailsService, (String)"clientDetailsService");
        Intrinsics.checkNotNullParameter((Object)oauth2RequestFactory, (String)"oauth2RequestFactory");
        Intrinsics.checkNotNullParameter((Object)tokenServices, (String)"tokenServices");
        this.eventPublisher = eventPublisher;
        this.clientDetailsService = clientDetailsService;
        this.oauth2RequestFactory = oauth2RequestFactory;
        this.tokenServices = tokenServices;
    }
}

