/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2.configuration;

import com.labijie.infra.oauth2.DefaultAuthenticationProvider;
import com.labijie.infra.oauth2.DefaultUserService;
import com.labijie.infra.oauth2.IClientDetailsServiceFactory;
import com.labijie.infra.oauth2.IIdentityService;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.servlet.UserDetailsServiceAutoConfiguration;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.endpoint.AuthorizationEndpoint;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;

@AutoConfigureBefore(value={UserDetailsServiceAutoConfiguration.class})
@ConditionalOnBean(value={AuthorizationEndpoint.class})
@Configuration
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0017J\b\u0010\f\u001a\u00020\rH\u0017R\u0010\u0010\u0002\u001a\u00020\u00038\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/labijie/infra/oauth2/configuration/OAuth2CustomizationAutoConfiguration;", "", "identityService", "Lcom/labijie/infra/oauth2/IIdentityService;", "(Lcom/labijie/infra/oauth2/IIdentityService;)V", "defaultClientDetailsService", "Lorg/springframework/security/oauth2/provider/ClientDetailsService;", "clientDetailsServiceFactory", "Lcom/labijie/infra/oauth2/IClientDetailsServiceFactory;", "defaultOAuth2RequestFactory", "Lorg/springframework/security/oauth2/provider/request/DefaultOAuth2RequestFactory;", "clientDetailsService", "userDetailService", "Lcom/labijie/infra/oauth2/DefaultUserService;", "AuthenticationProviderAutoConfiguration", "OAuth2PasswordEncoderConfiguration", "oauth2-starter"})
public class OAuth2CustomizationAutoConfiguration {
    @JvmField
    private final IIdentityService identityService;

    @Bean
    @NotNull
    public DefaultUserService userDetailService() {
        return new DefaultUserService(this.identityService);
    }

    @Primary
    @Bean
    @NotNull
    public ClientDetailsService defaultClientDetailsService(@NotNull IClientDetailsServiceFactory clientDetailsServiceFactory) {
        Intrinsics.checkNotNullParameter((Object)clientDetailsServiceFactory, (String)"clientDetailsServiceFactory");
        return clientDetailsServiceFactory.createClientDetailsService();
    }

    @Bean
    @NotNull
    public DefaultOAuth2RequestFactory defaultOAuth2RequestFactory(@NotNull ClientDetailsService clientDetailsService) {
        Intrinsics.checkNotNullParameter((Object)clientDetailsService, (String)"clientDetailsService");
        return new DefaultOAuth2RequestFactory(clientDetailsService);
    }

    public OAuth2CustomizationAutoConfiguration(@NotNull IIdentityService identityService) {
        Intrinsics.checkNotNullParameter((Object)identityService, (String)"identityService");
        this.identityService = identityService;
    }

    @Configuration
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0015\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0005"}, d2={"Lcom/labijie/infra/oauth2/configuration/OAuth2CustomizationAutoConfiguration$OAuth2PasswordEncoderConfiguration;", "", "()V", "oauth2PasswordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "oauth2-starter"})
    protected static class OAuth2PasswordEncoderConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={PasswordEncoder.class})
        @NotNull
        public PasswordEncoder oauth2PasswordEncoder() {
            DelegatingPasswordEncoder encoder;
            PasswordEncoder passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
            if (passwordEncoder == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.springframework.security.crypto.password.DelegatingPasswordEncoder");
            }
            DelegatingPasswordEncoder delegatingPasswordEncoder = encoder = (DelegatingPasswordEncoder)passwordEncoder;
            boolean bl = false;
            boolean bl2 = false;
            DelegatingPasswordEncoder $this$apply = delegatingPasswordEncoder;
            boolean bl3 = false;
            $this$apply.setDefaultPasswordEncoderForMatches((PasswordEncoder)new BCryptPasswordEncoder());
            return (PasswordEncoder)delegatingPasswordEncoder;
        }
    }

    @Configuration
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0015\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lcom/labijie/infra/oauth2/configuration/OAuth2CustomizationAutoConfiguration$AuthenticationProviderAutoConfiguration;", "", "()V", "defaultAuthenticationProvider", "Lcom/labijie/infra/oauth2/DefaultAuthenticationProvider;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "userDetailService", "Lcom/labijie/infra/oauth2/DefaultUserService;", "oauth2-starter"})
    protected static class AuthenticationProviderAutoConfiguration {
        @Primary
        @Bean
        @NotNull
        public DefaultAuthenticationProvider defaultAuthenticationProvider(@NotNull ApplicationEventPublisher eventPublisher, @NotNull PasswordEncoder passwordEncoder, @NotNull DefaultUserService userDetailService) {
            Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
            Intrinsics.checkNotNullParameter((Object)passwordEncoder, (String)"passwordEncoder");
            Intrinsics.checkNotNullParameter((Object)userDetailService, (String)"userDetailService");
            return new DefaultAuthenticationProvider(eventPublisher, userDetailService, passwordEncoder);
        }
    }
}

