/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2.configuration;

import com.labijie.infra.oauth2.CompositeOAuth2RequestValidator;
import com.labijie.infra.oauth2.TwoFactorSignInHelper;
import com.labijie.infra.oauth2.configuration.OAuth2CustomizationAutoConfiguration;
import com.labijie.infra.oauth2.configuration.OAuth2ServerProperties;
import com.labijie.infra.oauth2.error.IOAuth2ExceptionHandler;
import com.labijie.infra.oauth2.filter.ClientDetailsArgumentResolver;
import com.labijie.infra.oauth2.filter.ClientDetailsInterceptorAdapter;
import com.labijie.infra.oauth2.preauth.TwoFactorPreAuthenticationProvider;
import com.labijie.infra.oauth2.token.UserInfoTokenEnhancer;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.endpoint.AuthorizationEndpoint;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnBean(value={AuthorizationEndpoint.class})
@Configuration
@AutoConfigureAfter(value={OAuth2CustomizationAutoConfiguration.class})
@AutoConfigureBefore(value={AuthorizationServerEndpointsConfiguration.class})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002$%BO\b\u0007\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0017R\u0012\u0010\b\u001a\u0004\u0018\u00010\t8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/labijie/infra/oauth2/configuration/OAuth2ServerAutoConfiguration;", "Lorg/springframework/security/oauth2/config/annotation/web/configuration/AuthorizationServerConfigurerAdapter;", "oauth2ExceptionHandler", "Lcom/labijie/infra/oauth2/error/IOAuth2ExceptionHandler;", "serverProperties", "Lcom/labijie/infra/oauth2/configuration/OAuth2ServerProperties;", "oauth2RequestFactory", "Lorg/springframework/security/oauth2/provider/OAuth2RequestFactory;", "accessTokenConverter", "Lorg/springframework/security/oauth2/provider/token/AccessTokenConverter;", "authenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "userDetailsService", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "clientDetailsService", "Lorg/springframework/security/oauth2/provider/ClientDetailsService;", "tokenStore", "Lorg/springframework/security/oauth2/provider/token/TokenStore;", "(Lcom/labijie/infra/oauth2/error/IOAuth2ExceptionHandler;Lcom/labijie/infra/oauth2/configuration/OAuth2ServerProperties;Lorg/springframework/security/oauth2/provider/OAuth2RequestFactory;Lorg/springframework/security/oauth2/provider/token/AccessTokenConverter;Lorg/springframework/security/authentication/AuthenticationManager;Lorg/springframework/security/core/userdetails/UserDetailsService;Lorg/springframework/security/oauth2/provider/ClientDetailsService;Lorg/springframework/security/oauth2/provider/token/TokenStore;)V", "configure", "", "clients", "Lorg/springframework/security/oauth2/config/annotation/configurers/ClientDetailsServiceConfigurer;", "endpoints", "Lorg/springframework/security/oauth2/config/annotation/web/configurers/AuthorizationServerEndpointsConfigurer;", "security", "Lorg/springframework/security/oauth2/config/annotation/web/configurers/AuthorizationServerSecurityConfigurer;", "createAuthServerTokenServices", "Lorg/springframework/security/oauth2/provider/token/AuthorizationServerTokenServices;", "tokenEnhancer", "Lorg/springframework/security/oauth2/provider/token/TokenEnhancer;", "twoFactorSignInHelper", "Lcom/labijie/infra/oauth2/TwoFactorSignInHelper;", "tokenServices", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "ClientDetailsMvcAutoConfiguration", "NonePasswordEncoder", "oauth2-starter"})
public class OAuth2ServerAutoConfiguration
extends AuthorizationServerConfigurerAdapter {
    @JvmField
    private final IOAuth2ExceptionHandler oauth2ExceptionHandler;
    @JvmField
    private final OAuth2ServerProperties serverProperties;
    @JvmField
    private final OAuth2RequestFactory oauth2RequestFactory;
    @JvmField
    private final AccessTokenConverter accessTokenConverter;
    @JvmField
    private final AuthenticationManager authenticationManager;
    @JvmField
    private final UserDetailsService userDetailsService;
    @JvmField
    private final ClientDetailsService clientDetailsService;
    @JvmField
    private final TokenStore tokenStore;

    private AuthorizationServerTokenServices createAuthServerTokenServices(TokenEnhancer tokenEnhancer) {
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setClientDetailsService(this.clientDetailsService);
        tokenServices.setTokenStore(this.tokenStore);
        tokenServices.setTokenEnhancer(tokenEnhancer);
        tokenServices.setReuseRefreshToken(this.serverProperties.getToken().getReuseRefreshToken());
        tokenServices.setSupportRefreshToken(this.serverProperties.getToken().getRefreshTokenEnabled());
        tokenServices.setAccessTokenValiditySeconds(Math.max(1, (int)this.serverProperties.getToken().getAccessTokenExpiration().getSeconds()));
        tokenServices.setRefreshTokenValiditySeconds(Math.max(1, (int)this.serverProperties.getToken().getRefreshTokenExpiration().getSeconds()));
        TwoFactorPreAuthenticationProvider provider = new TwoFactorPreAuthenticationProvider();
        provider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new UserDetailsByNameServiceWrapper(this.userDetailsService));
        tokenServices.setAuthenticationManager((AuthenticationManager)new ProviderManager(Arrays.asList((AuthenticationProvider)provider)));
        return (AuthorizationServerTokenServices)tokenServices;
    }

    @Bean
    @NotNull
    public TwoFactorSignInHelper twoFactorSignInHelper(@NotNull AuthorizationServerTokenServices tokenServices, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)tokenServices, (String)"tokenServices");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        return new TwoFactorSignInHelper(eventPublisher, this.clientDetailsService, this.oauth2RequestFactory, tokenServices);
    }

    public void configure(@NotNull AuthorizationServerSecurityConfigurer security) {
        Intrinsics.checkNotNullParameter((Object)security, (String)"security");
        security.passwordEncoder((PasswordEncoder)new NonePasswordEncoder());
        security.checkTokenAccess("permitAll()");
        security.allowFormAuthenticationForClients();
    }

    public void configure(@NotNull AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        TokenEnhancer tokenEnhancer;
        Intrinsics.checkNotNullParameter((Object)endpoints, (String)"endpoints");
        endpoints.requestValidator((OAuth2RequestValidator)new CompositeOAuth2RequestValidator(this.serverProperties));
        if (this.accessTokenConverter instanceof JwtAccessTokenConverter) {
            TokenEnhancerChain tokenEnhancerChain = new TokenEnhancerChain();
            tokenEnhancerChain.setTokenEnhancers(CollectionsKt.listOf((Object[])new TokenEnhancer[]{new UserInfoTokenEnhancer(), (TokenEnhancer)this.accessTokenConverter}));
            tokenEnhancer = (TokenEnhancer)tokenEnhancerChain;
        } else {
            tokenEnhancer = new UserInfoTokenEnhancer();
        }
        TokenEnhancer enhancer = tokenEnhancer;
        AuthorizationServerTokenServices tokenService = this.createAuthServerTokenServices(enhancer);
        endpoints.tokenServices(tokenService);
        endpoints.tokenEnhancer(enhancer);
        endpoints.tokenStore(this.tokenStore);
        if (this.accessTokenConverter != null) {
            endpoints.accessTokenConverter(this.accessTokenConverter);
        }
        endpoints.authenticationManager(this.authenticationManager);
        endpoints.userDetailsService(this.userDetailsService);
        endpoints.allowedTokenEndpointRequestMethods(new HttpMethod[]{HttpMethod.POST});
        if (this.oauth2ExceptionHandler != null) {
            endpoints.exceptionTranslator((WebResponseExceptionTranslator)this.oauth2ExceptionHandler);
        }
    }

    public void configure(@NotNull ClientDetailsServiceConfigurer clients) {
        Intrinsics.checkNotNullParameter((Object)clients, (String)"clients");
        clients.withClientDetails(this.clientDetailsService);
    }

    @Autowired
    public OAuth2ServerAutoConfiguration(@Autowired(required=false) @Nullable IOAuth2ExceptionHandler oauth2ExceptionHandler, @NotNull OAuth2ServerProperties serverProperties, @NotNull OAuth2RequestFactory oauth2RequestFactory, @Autowired(required=false) @Nullable AccessTokenConverter accessTokenConverter, @NotNull AuthenticationManager authenticationManager, @NotNull UserDetailsService userDetailsService, @NotNull ClientDetailsService clientDetailsService, @NotNull TokenStore tokenStore) {
        Intrinsics.checkNotNullParameter((Object)serverProperties, (String)"serverProperties");
        Intrinsics.checkNotNullParameter((Object)oauth2RequestFactory, (String)"oauth2RequestFactory");
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)userDetailsService, (String)"userDetailsService");
        Intrinsics.checkNotNullParameter((Object)clientDetailsService, (String)"clientDetailsService");
        Intrinsics.checkNotNullParameter((Object)tokenStore, (String)"tokenStore");
        this.oauth2ExceptionHandler = oauth2ExceptionHandler;
        this.serverProperties = serverProperties;
        this.oauth2RequestFactory = oauth2RequestFactory;
        this.accessTokenConverter = accessTokenConverter;
        this.authenticationManager = authenticationManager;
        this.userDetailsService = userDetailsService;
        this.clientDetailsService = clientDetailsService;
        this.tokenStore = tokenStore;
    }

    @Configuration
    @ConditionalOnBean(value={ClientDetailsService.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0015\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/labijie/infra/oauth2/configuration/OAuth2ServerAutoConfiguration$ClientDetailsMvcAutoConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "()V", "clientDetailsService", "Lorg/springframework/security/oauth2/provider/ClientDetailsService;", "addArgumentResolvers", "", "resolvers", "", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "addInterceptors", "registry", "Lorg/springframework/web/servlet/config/annotation/InterceptorRegistry;", "oauth2-starter"})
    protected static class ClientDetailsMvcAutoConfiguration
    implements WebMvcConfigurer {
        @Autowired
        private ClientDetailsService clientDetailsService;

        public void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> resolvers) {
            Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
            ClientDetailsService clientDetailsService = this.clientDetailsService;
            if (clientDetailsService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clientDetailsService");
            }
            resolvers.add(new ClientDetailsArgumentResolver(clientDetailsService));
        }

        public void addInterceptors(@NotNull InterceptorRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            ClientDetailsService clientDetailsService = this.clientDetailsService;
            if (clientDetailsService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clientDetailsService");
            }
            registry.addInterceptor((HandlerInterceptor)new ClientDetailsInterceptorAdapter(clientDetailsService));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/labijie/infra/oauth2/configuration/OAuth2ServerAutoConfiguration$NonePasswordEncoder;", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "()V", "encode", "", "rawPassword", "", "matches", "", "encodedPassword", "oauth2-starter"})
    private static final class NonePasswordEncoder
    implements PasswordEncoder {
        @NotNull
        public String encode(@NotNull CharSequence rawPassword) {
            Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
            return ((Object)rawPassword).toString();
        }

        public boolean matches(@NotNull CharSequence rawPassword, @NotNull String encodedPassword) {
            Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
            Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
            return Intrinsics.areEqual((Object)((Object)rawPassword).toString(), (Object)encodedPassword);
        }
    }
}

