/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2.configuration;

import com.labijie.infra.oauth2.AuthorizationServerSwitch;
import com.labijie.infra.oauth2.ResourceServerSwitch;
import com.labijie.infra.oauth2.annotation.EnableOAuth2Server;
import com.labijie.infra.oauth2.annotation.OAuth2ServerType;
import com.labijie.infra.oauth2.annotation.TokenStoreType;
import com.labijie.infra.oauth2.configuration.TokenStoreImportSelector$WhenMappings;
import com.labijie.infra.oauth2.configuration.WebSecurityAutoConfiguration;
import com.labijie.infra.oauth2.configuration.token.InMemoryTokenStoreConfiguration;
import com.labijie.infra.oauth2.configuration.token.JwtTokenStoreConfiguration;
import com.labijie.infra.oauth2.configuration.token.RedisTokenStoreConfiguration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/labijie/infra/oauth2/configuration/TokenStoreImportSelector;", "Lorg/springframework/context/annotation/ImportSelector;", "()V", "selectImports", "", "", "importingClassMetadata", "Lorg/springframework/core/type/AnnotationMetadata;", "(Lorg/springframework/core/type/AnnotationMetadata;)[Ljava/lang/String;", "oauth2-starter"})
public final class TokenStoreImportSelector
implements ImportSelector {
    @NotNull
    public String[] selectImports(@NotNull AnnotationMetadata importingClassMetadata) {
        Intrinsics.checkNotNullParameter((Object)importingClassMetadata, (String)"importingClassMetadata");
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableOAuth2Server.class.getName());
        boolean bl = false;
        Set beans = new LinkedHashSet();
        Map map = attributes;
        Intrinsics.checkNotNull((Object)map);
        Object v = map.get("tokeStore");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.labijie.infra.oauth2.annotation.TokenStoreType");
        }
        TokenStoreType tokenStoreType = (TokenStoreType)((Object)v);
        switch (TokenStoreImportSelector$WhenMappings.$EnumSwitchMapping$0[tokenStoreType.ordinal()]) {
            case 1: {
                String string = JwtTokenStoreConfiguration.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JwtTokenStoreConfiguration::class.java.name");
                beans.add(string);
                break;
            }
            case 2: {
                String string = RedisTokenStoreConfiguration.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RedisTokenStoreConfiguration::class.java.name");
                beans.add(string);
                break;
            }
            case 3: {
                String string = InMemoryTokenStoreConfiguration.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"InMemoryTokenStoreConfiguration::class.java.name");
                beans.add(string);
                break;
            }
        }
        Object v2 = attributes.get("include");
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<com.labijie.infra.oauth2.annotation.OAuth2ServerType>");
        }
        OAuth2ServerType[] serverTypes = (OAuth2ServerType[])v2;
        if (ArraysKt.contains((Object[])serverTypes, (Object)((Object)OAuth2ServerType.Authorization))) {
            String string = AuthorizationServerSwitch.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AuthorizationServerSwitch::class.java.name");
            beans.add(string);
            String string2 = WebSecurityAutoConfiguration.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"WebSecurityAutoConfiguration::class.java.name");
            beans.add(string2);
        }
        if (ArraysKt.contains((Object[])serverTypes, (Object)((Object)OAuth2ServerType.Resource))) {
            String string = ResourceServerSwitch.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ResourceServerSwitch::class.java.name");
            beans.add(string);
        }
        Collection $this$toTypedArray$iv = beans;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }
}

