/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2.configuration.token;

import com.labijie.infra.oauth2.AuthorizationServerSwitch;
import com.labijie.infra.oauth2.ResourceServerSwitch;
import com.labijie.infra.oauth2.RsaUtils;
import com.labijie.infra.oauth2.configuration.OAuth2ServerProperties;
import com.labijie.infra.oauth2.configuration.token.JwtTokenStoreConfiguration$WhenMappings;
import com.labijie.infra.oauth2.token.TwoFactorAuthenticationConverter;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00072\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0003J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/labijie/infra/oauth2/configuration/token/JwtTokenStoreConfiguration;", "", "()V", "isAuthenticationServer", "", "isResourceServer", "configAuthenticationRSA", "", "converter", "Lorg/springframework/security/oauth2/provider/token/store/JwtAccessTokenConverter;", "oAuth2Config", "Lcom/labijie/infra/oauth2/configuration/OAuth2ServerProperties;", "init", "resourceServerConfiguration", "Lcom/labijie/infra/oauth2/AuthorizationServerSwitch;", "serverConfiguration", "Lcom/labijie/infra/oauth2/ResourceServerSwitch;", "jwtAccessTokenConverter", "jwtTokenStore", "Lorg/springframework/security/oauth2/provider/token/TokenStore;", "Companion", "oauth2-starter"})
public final class JwtTokenStoreConfiguration {
    private boolean isAuthenticationServer;
    private boolean isResourceServer;
    private static final Logger logger;
    public static final Companion Companion;

    @Autowired
    private final void init(@Autowired(required=false) AuthorizationServerSwitch resourceServerConfiguration, @Autowired(required=false) ResourceServerSwitch serverConfiguration) {
        this.isAuthenticationServer = serverConfiguration != null;
        this.isResourceServer = resourceServerConfiguration != null;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @NotNull
    public final JwtAccessTokenConverter jwtAccessTokenConverter(@NotNull OAuth2ServerProperties oAuth2Config) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)oAuth2Config, (String)"oAuth2Config");
        JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
        DefaultAccessTokenConverter defaultAccessTokenConverter = new DefaultAccessTokenConverter();
        boolean bl = false;
        boolean bl2 = false;
        DefaultAccessTokenConverter defaultAccessTokenConverter2 = defaultAccessTokenConverter;
        JwtAccessTokenConverter jwtAccessTokenConverter = converter;
        boolean bl3 = false;
        $this$apply.setUserTokenConverter((UserAuthenticationConverter)TwoFactorAuthenticationConverter.INSTANCE);
        Unit unit = Unit.INSTANCE;
        jwtAccessTokenConverter.setAccessTokenConverter((AccessTokenConverter)defaultAccessTokenConverter);
        switch (JwtTokenStoreConfiguration$WhenMappings.$EnumSwitchMapping$0[oAuth2Config.getToken().getJwt().getKeyType().ordinal()]) {
            case 1: {
                if (!this.isAuthenticationServer) break;
                this.configAuthenticationRSA(converter, oAuth2Config);
                break;
            }
            case 2: {
                if (StringsKt.isBlank((CharSequence)oAuth2Config.getToken().getJwt().getSimpleKey())) {
                    throw (Throwable)new IllegalArgumentException("miss configuration property: infra.oauth2.token.jwt.simpleKey");
                }
                converter.setSigningKey(oAuth2Config.getToken().getJwt().getSimpleKey());
                break;
            }
        }
        logger.info("Jwt token is used, key type: " + (Object)((Object)oAuth2Config.getToken().getJwt().getKeyType()));
        return converter;
    }

    private final void configAuthenticationRSA(JwtAccessTokenConverter converter, OAuth2ServerProperties oAuth2Config) {
        if (StringsKt.isBlank((CharSequence)oAuth2Config.getToken().getJwt().getRsa().getPrivateKey())) {
            throw (Throwable)new IllegalArgumentException("miss configuration property: infra.oauth2.token.jwt.rsa.privateKey");
        }
        if (StringsKt.isBlank((CharSequence)oAuth2Config.getToken().getJwt().getRsa().getPrivateKey())) {
            throw (Throwable)new IllegalArgumentException("miss configuration property: infra.oauth2.token.jwt.rsa.privateKey");
        }
        PrivateKey privateKey = RsaUtils.INSTANCE.getPrivateKey(oAuth2Config.getToken().getJwt().getRsa().getPrivateKey());
        PublicKey publicKey = RsaUtils.INSTANCE.getPublicKey(oAuth2Config.getToken().getJwt().getRsa().getPublicKey());
        converter.setKeyPair(new KeyPair(publicKey, privateKey));
    }

    @Bean
    @NotNull
    public final TokenStore jwtTokenStore(@NotNull JwtAccessTokenConverter converter) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        return (TokenStore)new JwtTokenStore(converter);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(JwtTokenStoreConfiguration.class);
        Intrinsics.checkNotNull((Object)logger);
        JwtTokenStoreConfiguration.logger = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/labijie/infra/oauth2/configuration/token/JwtTokenStoreConfiguration$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "oauth2-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

