/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2.filter;

import com.labijie.infra.oauth2.OAuth2Utils;
import com.labijie.infra.oauth2.filter.ClientDetailsHolder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/labijie/infra/oauth2/filter/ClientDetailsArgumentResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "clientDetailsService", "Lorg/springframework/security/oauth2/provider/ClientDetailsService;", "(Lorg/springframework/security/oauth2/provider/ClientDetailsService;)V", "resolveArgument", "", "parameter", "Lorg/springframework/core/MethodParameter;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "supportsParameter", "", "oauth2-starter"})
public final class ClientDetailsArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ClientDetailsService clientDetailsService;

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Class clazz = parameter.getParameterType();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"parameter.parameterType");
        Class type = clazz;
        return Intrinsics.areEqual(ClientDetails.class, (Object)type);
    }

    @Nullable
    public Object resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        OAuth2Authentication auth;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        ClientDetails clientDetails = ClientDetailsHolder.INSTANCE.getClient();
        if (clientDetails != null) {
            return clientDetails;
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        Authentication authentication = securityContext.getAuthentication();
        if (!(authentication instanceof OAuth2Authentication)) {
            authentication = null;
        }
        if ((auth = (OAuth2Authentication)authentication) != null && auth.isAuthenticated()) {
            OAuth2Request oAuth2Request = auth.getOAuth2Request();
            Intrinsics.checkNotNullExpressionValue((Object)oAuth2Request, (String)"auth.oAuth2Request");
            String clientId = oAuth2Request.getClientId();
            return this.clientDetailsService.loadClientByClientId(clientId);
        }
        String string = webRequest.getHeader("Authorization");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String headerValue = string2;
        Pair<String, String> pair = OAuth2Utils.INSTANCE.extractClientIdAndSecretFromHeaderValue(headerValue);
        String clientId = (String)pair.component1();
        return StringsKt.isBlank((CharSequence)clientId) ? null : this.clientDetailsService.loadClientByClientId(clientId);
    }

    public ClientDetailsArgumentResolver(@NotNull ClientDetailsService clientDetailsService) {
        Intrinsics.checkNotNullParameter((Object)clientDetailsService, (String)"clientDetailsService");
        this.clientDetailsService = clientDetailsService;
    }
}

