/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2.filter;

import com.labijie.infra.oauth2.OAuth2Utils;
import com.labijie.infra.oauth2.filter.ClientDetailsHolder;
import com.labijie.infra.oauth2.filter.ClientRequired;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/labijie/infra/oauth2/filter/ClientDetailsInterceptorAdapter;", "Lorg/springframework/web/servlet/handler/HandlerInterceptorAdapter;", "clientDetailsService", "Lorg/springframework/security/oauth2/provider/ClientDetailsService;", "(Lorg/springframework/security/oauth2/provider/ClientDetailsService;)V", "afterCompletion", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "handler", "", "ex", "Ljava/lang/Exception;", "preHandle", "", "oauth2-starter"})
public final class ClientDetailsInterceptorAdapter
extends HandlerInterceptorAdapter {
    private final ClientDetailsService clientDetailsService;

    /*
     * WARNING - void declaration
     */
    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        ClientRequired annotation;
        HandlerMethod method;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Object object = handler;
        if (!(object instanceof HandlerMethod)) {
            object = null;
        }
        if ((method = (HandlerMethod)object) != null && (annotation = (ClientRequired)method.getMethodAnnotation(ClientRequired.class)) != null) {
            ClientDetails clientDetail;
            void clientId;
            Pair<String, String> pair = OAuth2Utils.INSTANCE.extractClientIdAndSecretFromHeader(request);
            String string = (String)pair.component1();
            String secret = (String)pair.component2();
            if (StringsKt.isBlank((CharSequence)((CharSequence)clientId))) {
                response.sendError(401, "client id and secret required");
                return false;
            }
            ClientDetails clientDetails = clientDetail = this.clientDetailsService.loadClientByClientId((String)clientId);
            Intrinsics.checkNotNullExpressionValue((Object)clientDetails, (String)"clientDetail");
            if (clientDetails.isSecretRequired()) {
                String string2 = clientDetail.getClientSecret();
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                if (!StringsKt.equals((String)string3, (String)secret, (boolean)false)) {
                    response.sendError(401, "invalid client");
                    return false;
                }
            }
            ClientDetailsHolder.INSTANCE.setContext(clientDetail);
        }
        return true;
    }

    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, @Nullable Exception ex) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        ClientDetailsHolder.INSTANCE.clearContext();
        super.afterCompletion(request, response, handler, ex);
    }

    public ClientDetailsInterceptorAdapter(@NotNull ClientDetailsService clientDetailsService) {
        Intrinsics.checkNotNullParameter((Object)clientDetailsService, (String)"clientDetailsService");
        this.clientDetailsService = clientDetailsService;
    }
}

