/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2.security;

import com.labijie.infra.oauth2.ExtensionMethodsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lcom/labijie/infra/oauth2/security/OAuth2TwoFactorExpressionRoot;", "Lorg/springframework/security/web/access/expression/WebSecurityExpressionRoot;", "a", "Lorg/springframework/security/core/Authentication;", "fi", "Lorg/springframework/security/web/FilterInvocation;", "(Lorg/springframework/security/core/Authentication;Lorg/springframework/security/web/FilterInvocation;)V", "hasAttachedFieldValue", "", "fieldName", "", "value", "twoFactorRequired", "oauth2-starter"})
public final class OAuth2TwoFactorExpressionRoot
extends WebSecurityExpressionRoot {
    public final boolean twoFactorRequired() {
        Authentication authentication = this.authentication;
        Intrinsics.checkNotNullExpressionValue((Object)authentication, (String)"this.authentication");
        return ExtensionMethodsKt.isTwoFactorGranted(authentication);
    }

    public final boolean hasAttachedFieldValue(@NotNull String fieldName, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Authentication authentication = this.authentication;
        Intrinsics.checkNotNullExpressionValue((Object)authentication, (String)"this.authentication");
        return Intrinsics.areEqual((Object)ExtensionMethodsKt.getAttachedField(authentication, fieldName), (Object)value);
    }

    public OAuth2TwoFactorExpressionRoot(@Nullable Authentication a, @Nullable FilterInvocation fi) {
        super(a, fi);
    }
}

