/*
 * Decompiled with CFR 0.152.
 */
package com.labijie.infra.oauth2.security;

import com.labijie.infra.oauth2.security.OAuth2TwoFactorExpressionRoot;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.expression.OAuth2WebSecurityExpressionHandler;
import org.springframework.security.web.FilterInvocation;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/labijie/infra/oauth2/security/OAuth2TwoFactorSecurityExpressionHandler;", "Lorg/springframework/security/oauth2/provider/expression/OAuth2WebSecurityExpressionHandler;", "()V", "resolver", "Lorg/springframework/security/authentication/AuthenticationTrustResolver;", "rolePrefix", "", "createSecurityExpressionRoot", "Lorg/springframework/security/access/expression/SecurityExpressionOperations;", "authentication", "Lorg/springframework/security/core/Authentication;", "fi", "Lorg/springframework/security/web/FilterInvocation;", "oauth2-starter"})
public final class OAuth2TwoFactorSecurityExpressionHandler
extends OAuth2WebSecurityExpressionHandler {
    private static AuthenticationTrustResolver resolver;
    private static String rolePrefix;
    public static final OAuth2TwoFactorSecurityExpressionHandler INSTANCE;

    @NotNull
    protected SecurityExpressionOperations createSecurityExpressionRoot(@NotNull Authentication authentication, @NotNull FilterInvocation fi) {
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        Intrinsics.checkNotNullParameter((Object)fi, (String)"fi");
        OAuth2TwoFactorExpressionRoot root = new OAuth2TwoFactorExpressionRoot(authentication, fi);
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        root.setTrustResolver(resolver);
        root.setRoleHierarchy(this.getRoleHierarchy());
        root.setDefaultRolePrefix(rolePrefix);
        return (SecurityExpressionOperations)root;
    }

    private OAuth2TwoFactorSecurityExpressionHandler() {
    }

    static {
        OAuth2TwoFactorSecurityExpressionHandler oAuth2TwoFactorSecurityExpressionHandler;
        INSTANCE = oAuth2TwoFactorSecurityExpressionHandler = new OAuth2TwoFactorSecurityExpressionHandler();
        resolver = (AuthenticationTrustResolver)new AuthenticationTrustResolverImpl();
        rolePrefix = "ROLE_";
    }
}

