/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class RedisClient {
    private ClientBootstrap bootstrap;
    private Timer timer;
    private ChannelGroup channels;
    private long timeout;
    private TimeUnit unit;

    public RedisClient(String host) {
        this(host, 6379);
    }

    public RedisClient(String host, int port) {
        ExecutorService connectors = Executors.newFixedThreadPool(1);
        ExecutorService workers = Executors.newCachedThreadPool();
        NioClientSocketChannelFactory factory = new NioClientSocketChannelFactory((Executor)connectors, (Executor)workers);
        InetSocketAddress addr = new InetSocketAddress(host, port);
        this.bootstrap = new ClientBootstrap((ChannelFactory)factory);
        this.bootstrap.setOption("remoteAddress", (Object)addr);
        this.setDefaultTimeout(60L, TimeUnit.SECONDS);
        this.channels = new DefaultChannelGroup();
        this.timer = new HashedWheelTimer();
    }

    public void setDefaultTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
        this.bootstrap.setOption("connectTimeoutMillis", (Object)unit.toMillis(timeout));
    }

    public RedisConnection<String, String> connect() {
        return this.connect(new Utf8StringCodec());
    }

    public RedisAsyncConnection<String, String> connectAsync() {
        return this.connectAsync(new Utf8StringCodec());
    }

    public RedisPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub(new Utf8StringCodec());
    }

    public <K, V> RedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        return new RedisConnection<K, V>(this.connectAsync(codec));
    }

    public <K, V> RedisAsyncConnection<K, V> connectAsync(RedisCodec<K, V> codec) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        CommandHandler handler = new CommandHandler(queue);
        RedisAsyncConnection connection = new RedisAsyncConnection(queue, codec, this.timeout, this.unit);
        return this.connect(handler, connection);
    }

    public <K, V> RedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        PubSubCommandHandler handler = new PubSubCommandHandler(queue, codec);
        RedisPubSubConnection connection = new RedisPubSubConnection(queue, codec, this.timeout, this.unit);
        return this.connect(handler, connection);
    }

    private <K, V, T extends RedisAsyncConnection<K, V>> T connect(CommandHandler<K, V> handler, T connection) {
        try {
            ConnectionWatchdog watchdog = new ConnectionWatchdog(this.bootstrap, this.channels, this.timer);
            ChannelPipeline pipeline = Channels.pipeline((ChannelHandler[])new ChannelHandler[]{watchdog, handler, connection});
            Channel channel = this.bootstrap.getFactory().newChannel(pipeline);
            ChannelFuture future = channel.connect((SocketAddress)this.bootstrap.getOption("remoteAddress"));
            future.await();
            if (!future.isSuccess()) {
                throw future.getCause();
            }
            watchdog.setReconnect(true);
            return connection;
        }
        catch (Throwable e) {
            throw new RedisException("Unable to connect", e);
        }
    }

    public void shutdown() {
        for (Channel c : this.channels) {
            ChannelPipeline pipeline = c.getPipeline();
            RedisAsyncConnection connection = (RedisAsyncConnection)pipeline.get(RedisAsyncConnection.class);
            connection.close();
        }
        ChannelGroupFuture future = this.channels.close();
        future.awaitUninterruptibly();
        this.bootstrap.releaseExternalResources();
    }
}

