/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.collection;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.util.ArrayUtil;
import com.lenovo.cloud.framework.common.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

public class ArrayUtils {
    @SafeVarargs
    public static <T> Consumer<T>[] append(Consumer<T> consumer, Consumer<T> ... consumerArray) {
        if (consumer == null) {
            return consumerArray;
        }
        Consumer[] consumerArray2 = (Consumer[])ArrayUtil.newArray(Consumer.class, (int)(1 + consumerArray.length));
        consumerArray2[0] = consumer;
        System.arraycopy(consumerArray, 0, consumerArray2, 1, consumerArray.length);
        return consumerArray2;
    }

    public static <T, V> V[] toArray(Collection<T> collection, Function<T, V> function) {
        return ArrayUtils.toArray(CollectionUtils.convertList(collection, function));
    }

    public static <T> T[] toArray(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return new Object[0];
        }
        return ArrayUtil.toArray(collection, (Class)IterUtil.getElementType(collection.iterator()));
    }

    public static <T> T get(T[] TArray, int n) {
        if (null == TArray || n >= TArray.length) {
            return null;
        }
        return TArray[n];
    }
}

