/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.date;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JodaUtils {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");

    public static DateTime now() {
        return DateTime.now();
    }

    public static DateTime nowPlusDays(int n) {
        return DateTime.now().plusDays(n);
    }

    public static String nowPlusDaysStr(int n) {
        return JodaUtils.format(JodaUtils.nowPlusDays(n));
    }

    public static String nowPlusDaysStr(int n, String string) {
        return JodaUtils.format(JodaUtils.nowPlusDays(n), string);
    }

    public static DateTime nowPlusDaysEndOfDay(int n) {
        return JodaUtils.nowPlusDays(n).millisOfDay().withMaximumValue();
    }

    public static String nowPlusDaysEndOfDayStr(int n) {
        return JodaUtils.format(JodaUtils.nowPlusDaysEndOfDay(n));
    }

    public static String nowPlusDaysEndOfDayStr(int n, String string) {
        return JodaUtils.format(JodaUtils.nowPlusDaysEndOfDay(n), string);
    }

    public static DateTime parse(String string) {
        return JodaUtils.parse(string, DEFAULT_PATTERN);
    }

    public static DateTime parse(String string, String string2) {
        return DateTimeFormat.forPattern((String)string2).parseDateTime(string);
    }

    public static String format(DateTime dateTime) {
        return JodaUtils.format(dateTime, DEFAULT_PATTERN);
    }

    public static String format(DateTime dateTime, String string) {
        return dateTime.toString(string);
    }

    public static DateTime toDateTime(Date date) {
        return new DateTime((Object)date);
    }

    public static Date toDate(DateTime dateTime) {
        return dateTime.toDate();
    }

    public static int daysBetween(DateTime dateTime, DateTime dateTime2) {
        return Days.daysBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getDays();
    }

    public static int hoursBetween(DateTime dateTime, DateTime dateTime2) {
        return Hours.hoursBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getHours();
    }

    public static int minutesBetween(DateTime dateTime, DateTime dateTime2) {
        return Minutes.minutesBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getMinutes();
    }

    public static DateTime getStartOfDay(DateTime dateTime) {
        return dateTime.withTimeAtStartOfDay();
    }

    public static DateTime getEndOfDay(DateTime dateTime) {
        return dateTime.millisOfDay().withMaximumValue();
    }

    public static DateTime getStartOfMonth(DateTime dateTime) {
        return dateTime.dayOfMonth().withMinimumValue().withTimeAtStartOfDay();
    }

    public static DateTime getEndOfMonth(DateTime dateTime) {
        return dateTime.dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue();
    }

    public static boolean isBetween(DateTime dateTime, DateTime dateTime2, DateTime dateTime3) {
        return dateTime.isAfter((ReadableInstant)dateTime2) && dateTime.isBefore((ReadableInstant)dateTime3);
    }

    public static DateTime plusDays(DateTime dateTime, int n) {
        return dateTime.plusDays(n);
    }

    public static DateTime plusMonths(DateTime dateTime, int n) {
        return dateTime.plusMonths(n);
    }

    public static DateTime plusYears(DateTime dateTime, int n) {
        return dateTime.plusYears(n);
    }
}

