/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.date;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.common.enums.DateIntervalEnum;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;

public class LocalDateTimeUtils {
    public static LocalDateTime EMPTY = LocalDateTimeUtils.buildTime(1970, 1, 1);

    public static LocalDateTime parse(String string) {
        try {
            return LocalDateTimeUtil.parse((CharSequence)string, (String)"yyyy-MM-dd");
        }
        catch (DateTimeParseException dateTimeParseException) {
            return LocalDateTimeUtil.parse((CharSequence)string);
        }
    }

    public static LocalDateTime addTime(Duration duration) {
        return LocalDateTime.now().plus(duration);
    }

    public static LocalDateTime minusTime(Duration duration) {
        return LocalDateTime.now().minus(duration);
    }

    public static boolean beforeNow(LocalDateTime localDateTime) {
        return localDateTime.isBefore(LocalDateTime.now());
    }

    public static boolean afterNow(LocalDateTime localDateTime) {
        return localDateTime.isAfter(LocalDateTime.now());
    }

    public static LocalDateTime buildTime(int n, int n2, int n3) {
        return LocalDateTime.of(n, n2, n3, 0, 0, 0);
    }

    public static LocalDateTime[] buildBetweenTime(int n, int n2, int n3, int n4, int n5, int n6) {
        return new LocalDateTime[]{LocalDateTimeUtils.buildTime(n, n2, n3), LocalDateTimeUtils.buildTime(n4, n5, n6)};
    }

    public static boolean isBetween(LocalDateTime localDateTime, LocalDateTime localDateTime2, String string) {
        if (localDateTime == null || localDateTime2 == null || string == null) {
            return false;
        }
        return LocalDateTimeUtil.isIn((ChronoLocalDateTime)LocalDateTimeUtils.parse(string), (ChronoLocalDateTime)localDateTime, (ChronoLocalDateTime)localDateTime2);
    }

    public static boolean isBetween(LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        if (localDateTime == null || localDateTime2 == null) {
            return false;
        }
        return LocalDateTimeUtil.isIn((ChronoLocalDateTime)LocalDateTime.now(), (ChronoLocalDateTime)localDateTime, (ChronoLocalDateTime)localDateTime2);
    }

    public static boolean isBetween(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        LocalDate localDate = LocalDate.now();
        return LocalDateTimeUtil.isIn((ChronoLocalDateTime)LocalDateTime.now(), (ChronoLocalDateTime)LocalDateTime.of(localDate, LocalTime.parse(string)), (ChronoLocalDateTime)LocalDateTime.of(localDate, LocalTime.parse(string2)));
    }

    public static boolean isOverlap(LocalTime localTime, LocalTime localTime2, LocalTime localTime3, LocalTime localTime4) {
        LocalDate localDate = LocalDate.now();
        return LocalDateTimeUtil.isOverlap((ChronoLocalDateTime)LocalDateTime.of(localDate, localTime), (ChronoLocalDateTime)LocalDateTime.of(localDate, localTime2), (ChronoLocalDateTime)LocalDateTime.of(localDate, localTime3), (ChronoLocalDateTime)LocalDateTime.of(localDate, localTime4));
    }

    public static LocalDateTime beginOfMonth(LocalDateTime localDateTime) {
        return localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
    }

    public static LocalDateTime endOfMonth(LocalDateTime localDateTime) {
        return localDateTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
    }

    public static int getQuarterOfYear(LocalDateTime localDateTime) {
        return (localDateTime.getMonthValue() - 1) / 3 + 1;
    }

    public static Long between(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.between((LocalDateTime)localDateTime, (LocalDateTime)LocalDateTime.now(), (ChronoUnit)ChronoUnit.DAYS);
    }

    public static LocalDateTime getToday() {
        return LocalDateTimeUtil.beginOfDay((LocalDateTime)LocalDateTime.now());
    }

    public static LocalDateTime getYesterday() {
        return LocalDateTimeUtil.beginOfDay((LocalDateTime)LocalDateTime.now().minusDays(1L));
    }

    public static LocalDateTime getMonth() {
        return LocalDateTimeUtils.beginOfMonth(LocalDateTime.now());
    }

    public static LocalDateTime getYear() {
        return LocalDateTime.now().with(TemporalAdjusters.firstDayOfYear()).with(LocalTime.MIN);
    }

    public static List<LocalDateTime[]> getDateRangeList(LocalDateTime localDateTime, LocalDateTime localDateTime2, Integer n) {
        LocalDateTime[] localDateTimeArray;
        DateIntervalEnum dateIntervalEnum = DateIntervalEnum.valueOf(n);
        Assert.notNull((Object)dateIntervalEnum, (String)"interval({}} \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u679a\u4e3e", (Object[])new Object[]{n});
        localDateTime = LocalDateTimeUtil.beginOfDay((LocalDateTime)localDateTime);
        localDateTime2 = LocalDateTimeUtil.endOfDay((LocalDateTime)localDateTime2);
        ArrayList<LocalDateTime[]> arrayList = new ArrayList<LocalDateTime[]>();
        switch (dateIntervalEnum) {
            case DAY: {
                while (localDateTime.isBefore(localDateTime2)) {
                    arrayList.add(new LocalDateTime[]{localDateTime, localDateTime.plusDays(1L).minusNanos(1L)});
                    localDateTime = localDateTime.plusDays(1L);
                }
                break;
            }
            case WEEK: {
                while (localDateTime.isBefore(localDateTime2)) {
                    LocalDateTime localDateTime3 = localDateTime.with(DayOfWeek.SUNDAY).plusDays(1L).minusNanos(1L);
                    arrayList.add(new LocalDateTime[]{localDateTime, localDateTime3});
                    localDateTime = localDateTime3.plusNanos(1L);
                }
                break;
            }
            case MONTH: {
                while (localDateTime.isBefore(localDateTime2)) {
                    LocalDateTime localDateTime4 = localDateTime.with(TemporalAdjusters.lastDayOfMonth()).plusDays(1L).minusNanos(1L);
                    arrayList.add(new LocalDateTime[]{localDateTime, localDateTime4});
                    localDateTime = localDateTime4.plusNanos(1L);
                }
                break;
            }
            case QUARTER: {
                while (localDateTime.isBefore(localDateTime2)) {
                    int n2 = LocalDateTimeUtils.getQuarterOfYear(localDateTime);
                    LocalDateTime localDateTime5 = n2 == 4 ? localDateTime.with(TemporalAdjusters.lastDayOfYear()).plusDays(1L).minusNanos(1L) : localDateTime.withMonth(n2 * 3 + 1).withDayOfMonth(1).minusNanos(1L);
                    arrayList.add(new LocalDateTime[]{localDateTime, localDateTime5});
                    localDateTime = localDateTime5.plusNanos(1L);
                }
                break;
            }
            case YEAR: {
                while (localDateTime.isBefore(localDateTime2)) {
                    LocalDateTime localDateTime6 = localDateTime.with(TemporalAdjusters.lastDayOfYear()).plusDays(1L).minusNanos(1L);
                    arrayList.add(new LocalDateTime[]{localDateTime, localDateTime6});
                    localDateTime = localDateTime6.plusNanos(1L);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid interval: " + n);
            }
        }
        if ((localDateTimeArray = (LocalDateTime[])CollUtil.getLast(arrayList)) != null) {
            localDateTimeArray[1] = localDateTime2;
        }
        return arrayList;
    }

    public static String formatDateRange(LocalDateTime localDateTime, LocalDateTime localDateTime2, Integer n) {
        DateIntervalEnum dateIntervalEnum = DateIntervalEnum.valueOf(n);
        Assert.notNull((Object)dateIntervalEnum, (String)"interval({}} \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u679a\u4e3e", (Object[])new Object[]{n});
        switch (dateIntervalEnum) {
            case DAY: {
                return LocalDateTimeUtil.format((LocalDateTime)localDateTime, (String)"yyyy-MM-dd");
            }
            case WEEK: {
                return LocalDateTimeUtil.format((LocalDateTime)localDateTime, (String)"yyyy-MM-dd") + StrUtil.format((CharSequence)"(\u7b2c {} \u5468)", (Object[])new Object[]{LocalDateTimeUtil.weekOfYear((TemporalAccessor)localDateTime)});
            }
            case MONTH: {
                return LocalDateTimeUtil.format((LocalDateTime)localDateTime, (String)"yyyy-MM");
            }
            case QUARTER: {
                return StrUtil.format((CharSequence)"{}-Q{}", (Object[])new Object[]{localDateTime.getYear(), LocalDateTimeUtils.getQuarterOfYear(localDateTime)});
            }
            case YEAR: {
                return LocalDateTimeUtil.format((LocalDateTime)localDateTime, (String)"yyyy");
            }
        }
        throw new IllegalArgumentException("Invalid interval: " + n);
    }
}

