/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.spring;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpringExpressionUtils {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();

    private SpringExpressionUtils() {
    }

    public static Object parseExpression(JoinPoint joinPoint, String string) {
        Map<String, Object> map = SpringExpressionUtils.parseExpressions(joinPoint, Collections.singletonList(string));
        return map.get(string);
    }

    public static Map<String, Object> parseExpressions(JoinPoint joinPoint, List<String> list) {
        Object object;
        if (CollUtil.isEmpty(list)) {
            return MapUtil.newHashMap();
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object[] objectArray = PARAMETER_NAME_DISCOVERER.getParameterNames(method);
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        if (ArrayUtil.isNotEmpty((Object[])objectArray)) {
            object = joinPoint.getArgs();
            for (int i = 0; i < objectArray.length; ++i) {
                standardEvaluationContext.setVariable((String)objectArray[i], object[i]);
            }
        }
        object = MapUtil.newHashMap((int)list.size(), (boolean)true);
        list.forEach(arg_0 -> SpringExpressionUtils.lambda$parseExpressions$0((EvaluationContext)standardEvaluationContext, (Map)object, arg_0));
        return object;
    }

    public static Object parseExpression(String string) {
        return SpringExpressionUtils.parseExpression(string, null);
    }

    public static Object parseExpression(String string, Map<String, Object> map) {
        if (StrUtil.isBlank((CharSequence)string)) {
            return null;
        }
        Expression expression = EXPRESSION_PARSER.parseExpression(string);
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        standardEvaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)SpringUtil.getApplicationContext()));
        if (MapUtil.isNotEmpty(map)) {
            standardEvaluationContext.setVariables(map);
        }
        return expression.getValue((EvaluationContext)standardEvaluationContext);
    }

    private static /* synthetic */ void lambda$parseExpressions$0(EvaluationContext evaluationContext, Map map, String string) {
        Object object = EXPRESSION_PARSER.parseExpression(string).getValue(evaluationContext);
        map.put(string, object);
    }
}

