/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.web;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Maps;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtils {
    public static final String JSONP_CALLBACK_NAME = "jsonpcallback";
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);

    private WebUtils() {
    }

    public static Map<String, Cookie> cookieMap(HttpServletRequest httpServletRequest) {
        HashMap hashMap = Maps.newHashMap();
        if (httpServletRequest.getCookies() != null) {
            for (Cookie cookie : httpServletRequest.getCookies()) {
                hashMap.put(cookie.getName(), cookie);
            }
        }
        return hashMap;
    }

    public static boolean isAjaxRequest(HttpServletRequest httpServletRequest) {
        return "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("X-Requested-With"));
    }

    public static String getIp(HttpServletRequest httpServletRequest) {
        String[] stringArray;
        String string = httpServletRequest.getHeader("x-forwarded-for");
        String string2 = "unknown";
        if (StrUtil.isEmpty((CharSequence)string) || string2.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (StrUtil.isEmpty((CharSequence)string) || string2.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (StrUtil.isEmpty((CharSequence)string) || string2.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("X-Real-IP");
        }
        if (StrUtil.isEmpty((CharSequence)string) || string2.equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        for (String string3 : stringArray = string.split(",")) {
            if (string2.equalsIgnoreCase(string3)) continue;
            string = string3;
            break;
        }
        return string;
    }

    public static String addParamsWithTimestamp(String object, Object ... objectArray) throws UnsupportedEncodingException {
        object = (String)object + (((String)object).indexOf("?") == -1 ? "?" : "&").concat(Long.toString(System.currentTimeMillis(), 36));
        return WebUtils.addParams((String)object, objectArray);
    }

    private static String addParams(String string, Object ... objectArray) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (objectArray != null) {
            int n = 0;
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object;
                if (objectArray.length <= i + 1 || (object = objectArray[i + 1]) == null) continue;
                if (n == 0) {
                    if (string.indexOf("?") != -1) {
                        stringBuilder.append("&");
                    } else {
                        stringBuilder.append("?");
                    }
                } else {
                    stringBuilder.append("&");
                }
                Object object2 = objectArray[i];
                stringBuilder.append(object2);
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(object.toString(), "UTF-8"));
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    public static String getAbsUrl(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getCharacterEncoding();
        string = string != null ? string : "UTF-8";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(WebUtils.getAbsUri(httpServletRequest));
        Map map = httpServletRequest.getParameterMap();
        if (!map.isEmpty()) {
            stringBuilder.append("?");
            for (String string2 : map.keySet()) {
                String[] stringArray;
                if (StrUtil.equals((CharSequence)string2, (CharSequence)"username") || StrUtil.equals((CharSequence)string2, (CharSequence)"password")) continue;
                for (String string3 : stringArray = (String[])map.get(string2)) {
                    if (stringBuilder.charAt(stringBuilder.length() - 1) != '?') {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append(string2);
                    stringBuilder.append('=');
                    try {
                        stringBuilder.append(URLEncoder.encode(string3, string));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        WebUtils.unchecked(unsupportedEncodingException);
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String getAbsUri(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(WebUtils.getAppUrl(httpServletRequest));
        stringBuilder.append(httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()));
        return stringBuilder.toString();
    }

    public static String getAppUrl(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("Host");
        if (string != null) {
            String string2 = httpServletRequest.getHeader("X-Forwarded-Proto");
            string2 = string2 != null ? string2 : httpServletRequest.getScheme();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("://");
            stringBuilder.append(string);
            stringBuilder.append(httpServletRequest.getContextPath());
            return stringBuilder.toString();
        }
        String string3 = httpServletRequest.getRequestURL().toString();
        int n = httpServletRequest.getRequestURI().length() - httpServletRequest.getContextPath().length();
        return string3.substring(0, string3.length() - n);
    }

    public static Cookie getCookie(HttpServletRequest httpServletRequest, String string) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                if (!cookie.getName().equals(string)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Map<String, Object> getParameterMap(String string, String string2) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        try {
            String[] stringArray;
            for (String string3 : stringArray = string.split("&")) {
                String string4;
                String string5;
                int n = string3.indexOf("=");
                if (n == -1) {
                    string5 = URLDecoder.decode(string3, string2);
                    string4 = null;
                } else {
                    string5 = URLDecoder.decode(string3.substring(0, n), string2);
                    String string6 = string4 = string3.length() > n + 1 ? URLDecoder.decode(string3.substring(n + 1), string2) : "";
                }
                if (linkedHashMap.containsKey(string5)) {
                    Object v = linkedHashMap.get(string5);
                    if (v != null && v.getClass().isArray()) {
                        String[] stringArray2 = (String[])v;
                        String[] stringArray3 = new String[stringArray2.length + 1];
                        System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                        stringArray3[stringArray2.length] = string4;
                        linkedHashMap.put(string5, stringArray3);
                        continue;
                    }
                    linkedHashMap.put(string5, new String[]{(String)v, string4});
                    continue;
                }
                linkedHashMap.put(string5, string4);
            }
        }
        catch (Exception exception) {
            WebUtils.unchecked(exception);
        }
        return linkedHashMap;
    }

    public static InetAddress getLocalAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error("UnknownHostException:", (Throwable)unknownHostException);
        }
        return inetAddress;
    }

    public static RuntimeException unchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }
}

