/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.pojo;

import cn.hutool.core.lang.Assert;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.lenovo.cloud.framework.common.exception.ErrorCode;
import com.lenovo.cloud.framework.common.exception.ServiceException;
import com.lenovo.cloud.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.lenovo.cloud.framework.common.exception.util.ServiceExceptionUtil;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

public class CommonResult<T>
implements Serializable {
    private Integer code;
    private T data;
    private String msg;

    public static <T> CommonResult<T> error(CommonResult<?> commonResult) {
        return CommonResult.error(commonResult.getCode(), commonResult.getMsg());
    }

    public static <T> CommonResult<T> error(Integer n, String string) {
        Assert.notEquals((Object)GlobalErrorCodeConstants.SUCCESS.getCode(), (Object)n, (String)"code \u5fc5\u987b\u662f\u9519\u8bef\u7684\uff01", (Object[])new Object[0]);
        CommonResult<T> commonResult = new CommonResult<T>();
        commonResult.code = n;
        commonResult.msg = string;
        return commonResult;
    }

    public static <T> CommonResult<T> error(ErrorCode errorCode, Object ... objectArray) {
        Assert.notEquals((Object)GlobalErrorCodeConstants.SUCCESS.getCode(), (Object)errorCode.getCode(), (String)"code \u5fc5\u987b\u662f\u9519\u8bef\u7684\uff01", (Object[])new Object[0]);
        CommonResult<T> commonResult = new CommonResult<T>();
        commonResult.code = errorCode.getCode();
        commonResult.msg = ServiceExceptionUtil.doFormat(errorCode.getCode(), errorCode.getMsg(), objectArray);
        return commonResult;
    }

    public static <T> CommonResult<T> error(ErrorCode errorCode) {
        return CommonResult.error(errorCode.getCode(), errorCode.getMsg());
    }

    public static <T> CommonResult<T> success(T t) {
        CommonResult<T> commonResult = new CommonResult<T>();
        commonResult.code = GlobalErrorCodeConstants.SUCCESS.getCode();
        commonResult.data = t;
        commonResult.msg = "";
        return commonResult;
    }

    public static boolean isSuccess(Integer n) {
        return Objects.equals(n, GlobalErrorCodeConstants.SUCCESS.getCode());
    }

    @JsonIgnore
    public boolean isSuccess() {
        return CommonResult.isSuccess(this.code);
    }

    @JsonIgnore
    public boolean isError() {
        return !this.isSuccess();
    }

    public void checkError() throws ServiceException {
        if (this.isSuccess()) {
            return;
        }
        throw new ServiceException(this.code, this.msg);
    }

    @JsonIgnore
    public T getCheckedData() {
        this.checkError();
        return this.data;
    }

    public static <T> CommonResult<T> error(ServiceException serviceException) {
        return CommonResult.error(serviceException.getCode(), serviceException.getMessage());
    }

    @Generated
    public CommonResult() {
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public CommonResult<T> setCode(Integer n) {
        this.code = n;
        return this;
    }

    @Generated
    public CommonResult<T> setData(T t) {
        this.data = t;
        return this;
    }

    @Generated
    public CommonResult<T> setMsg(String string) {
        this.msg = string;
        return this;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CommonResult)) {
            return false;
        }
        CommonResult commonResult = (CommonResult)object;
        if (!commonResult.canEqual(this)) {
            return false;
        }
        Integer n = this.getCode();
        Integer n2 = commonResult.getCode();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            return false;
        }
        T t = this.getData();
        T t2 = commonResult.getData();
        if (t == null ? t2 != null : !t.equals(t2)) {
            return false;
        }
        String string = this.getMsg();
        String string2 = commonResult.getMsg();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof CommonResult;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        Integer n2 = this.getCode();
        n = n * 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
        T t = this.getData();
        n = n * 59 + (t == null ? 43 : t.hashCode());
        String string = this.getMsg();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "CommonResult(code=" + this.getCode() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ")";
    }
}

