/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.request.page;

import com.lenovo.cloud.framework.common.request.AbstractBaseRequest;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

public abstract class AbstractPageRequest<T>
extends AbstractBaseRequest<T>
implements Serializable {
    protected static final Integer DEFAULT_PAGE_NUM = 0;
    protected static final Integer DEFAULT_PAGE_SIZE = 10;
    private static final Integer MAX_LIMIT = 10000;
    @NotNull
    private Integer pageNum = 0;
    @NotNull
    private Integer pageSize = 10;

    public AbstractPageRequest() {
    }

    public AbstractPageRequest(Integer n, Integer n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.pageNum = n;
        this.pageSize = n2;
    }

    public Integer getPageSize() {
        if (this.pageSize > MAX_LIMIT) {
            return MAX_LIMIT;
        }
        return this.pageSize;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer n) {
        this.pageNum = n;
    }

    public void setPageSize(Integer n) {
        this.pageSize = n;
    }

    public String toString() {
        return "AbstractPageRequest{requestId='" + this.requestId + "', requestDate='" + this.requestDate + "', timeOut=" + this.timeOut + ", token='" + this.token + "', data=" + this.data + ", pageNum=" + this.pageNum + ", pageSize=" + this.pageSize + "}";
    }
}

