/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.response;

import com.lenovo.cloud.framework.common.response.AbstractBaseResponse;
import com.lenovo.cloud.framework.common.response.enums.CommonResponseCodeEnum;
import java.io.Serializable;

public class BaseResponse<T>
extends AbstractBaseResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean success = true;
    private String message = CommonResponseCodeEnum.SUCCESS.getResultMsg();
    private String businessMessage;
    private String code = CommonResponseCodeEnum.SUCCESS.getResultCode();
    private T data;

    public BaseResponse() {
    }

    public static <T> BaseResponse<T> ok() {
        return BaseResponse.ok(null);
    }

    public static <T> BaseResponse<T> ok(T t) {
        BaseResponse<T> baseResponse = new BaseResponse<T>();
        baseResponse.setData(t);
        return baseResponse;
    }

    public static <T> BaseResponse<T> ok(String string, String string2) {
        BaseResponse<T> baseResponse = new BaseResponse<T>();
        baseResponse.setCode(string);
        baseResponse.setMessage(string2);
        return baseResponse;
    }

    public static <T> BaseResponse<T> ok(String string, String string2, T t) {
        BaseResponse<T> baseResponse = BaseResponse.ok(string, string2);
        baseResponse.setData(t);
        return baseResponse;
    }

    public static <T> BaseResponse<T> bad(String string) {
        return BaseResponse.error(CommonResponseCodeEnum.BAD_REQUEST.getResultCode(), string);
    }

    public static <T> BaseResponse<T> unauthorized(String string) {
        return BaseResponse.error(CommonResponseCodeEnum.UNAUTHORIZED.getResultCode(), string);
    }

    public static <T> BaseResponse<T> forbidden(String string) {
        return BaseResponse.error(CommonResponseCodeEnum.FORBIDDEN.getResultCode(), string);
    }

    public static <T> BaseResponse<T> notFind(String string) {
        return BaseResponse.error(CommonResponseCodeEnum.NOT_FOUND.getResultCode(), string);
    }

    public static <T> BaseResponse<T> error(String string) {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_ERROR.getResultCode(), string);
    }

    public static <T> BaseResponse<T> error(T t) {
        BaseResponse<T> baseResponse = new BaseResponse<T>();
        baseResponse.setCode(CommonResponseCodeEnum.SERVER_ERROR.getResultCode());
        baseResponse.setMessage(CommonResponseCodeEnum.SERVER_ERROR.getResultMsg());
        baseResponse.setData(t);
        return baseResponse;
    }

    public static <T> BaseResponse<T> error() {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_ERROR.getResultCode(), CommonResponseCodeEnum.SERVER_ERROR.getResultMsg());
    }

    public static <T> BaseResponse<T> unavailable(String string) {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_UNAVAILABLE.getResultCode(), string);
    }

    public static <T> BaseResponse<T> error(String string, String string2) {
        BaseResponse<T> baseResponse = new BaseResponse<T>();
        baseResponse.setSuccess(Boolean.FALSE);
        baseResponse.setCode(string);
        baseResponse.setMessage(string2);
        return baseResponse;
    }

    public static <T> BaseResponse<T> error(String string, String string2, T t) {
        BaseResponse<T> baseResponse = BaseResponse.error(string, string2);
        baseResponse.setData(t);
        return baseResponse;
    }

    public BaseResponse<T> code(String string) {
        this.code = string;
        return this;
    }

    public BaseResponse<T> message(String string) {
        this.message = string;
        return this;
    }

    public BaseResponse<T> result(T t) {
        this.data = t;
        return this;
    }

    public BaseResponse(boolean bl, String string, String string2, String string3, T t) {
        this.success = bl;
        this.message = string;
        this.businessMessage = string2;
        this.code = string3;
        this.data = t;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean bl) {
        this.success = bl;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getBusinessMessage() {
        return this.businessMessage;
    }

    public void setBusinessMessage(String string) {
        this.businessMessage = string;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T t) {
        this.data = t;
    }
}

