/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.spring.utils.content;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class ClassResourceLoaderAware
implements ResourceLoaderAware {
    private final List<TypeFilter> includeFilters = new LinkedList<TypeFilter>();
    private final List<TypeFilter> excludeFilters = new LinkedList<TypeFilter>();
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);

    @SafeVarargs
    public static Set<Class<?>> scan(String[] stringArray, Class<? extends Annotation> ... classArray) {
        ClassResourceLoaderAware classResourceLoaderAware = new ClassResourceLoaderAware();
        if (ArrayUtils.isNotEmpty((Object[])classArray)) {
            for (Class<? extends Annotation> clazz : classArray) {
                classResourceLoaderAware.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(clazz));
            }
        }
        HashSet hashSet = new HashSet();
        for (String string : stringArray) {
            hashSet.addAll(classResourceLoaderAware.doScan(string));
        }
        return hashSet;
    }

    @SafeVarargs
    public static Set<Class<?>> scan(String string, Class<? extends Annotation> ... classArray) {
        return ClassResourceLoaderAware.scan(StringUtils.tokenizeToStringArray((String)string, (String)",; \t\n"), classArray);
    }

    public final ResourceLoader getResourceLoader() {
        return this.resourcePatternResolver;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public void addIncludeFilter(TypeFilter typeFilter) {
        this.includeFilters.add(typeFilter);
    }

    public void addExcludeFilter(TypeFilter typeFilter) {
        this.excludeFilters.add(0, typeFilter);
    }

    public void resetFilters(boolean bl) {
        this.includeFilters.clear();
        this.excludeFilters.clear();
    }

    public Set<Class<?>> doScan(String string) {
        HashSet hashSet = new HashSet();
        try {
            String string2 = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)string)) + "/**/*.class";
            Resource[] resourceArray = this.resourcePatternResolver.getResources(string2);
            for (int i = 0; i < resourceArray.length; ++i) {
                Resource resource = resourceArray[i];
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                if ((this.includeFilters.size() != 0 || this.excludeFilters.size() != 0) && !this.matches(metadataReader)) continue;
                try {
                    hashSet.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)iOException);
        }
        return hashSet;
    }

    protected boolean matches(MetadataReader metadataReader) throws IOException {
        for (TypeFilter typeFilter : this.excludeFilters) {
            if (!typeFilter.match(metadataReader, this.metadataReaderFactory)) continue;
            return false;
        }
        for (TypeFilter typeFilter : this.includeFilters) {
            if (!typeFilter.match(metadataReader, this.metadataReaderFactory)) continue;
            return true;
        }
        return false;
    }
}

