/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.collection;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import com.google.common.collect.ImmutableMap;
import com.lenovo.cloud.framework.common.pojo.PageResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionUtils {
    public static boolean containsAny(Object object, Object ... objectArray) {
        return Arrays.asList(objectArray).contains(object);
    }

    public static boolean isAnyEmpty(Collection<?> ... collectionArray) {
        return Arrays.stream(collectionArray).anyMatch(CollUtil::isEmpty);
    }

    public static <T> boolean anyMatch(Collection<T> collection, Predicate<T> predicate) {
        return collection.stream().anyMatch(predicate);
    }

    public static <T> List<T> filterList(Collection<T> collection, Predicate<T> predicate) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T, R> List<T> distinct(Collection<T> collection, Function<T, R> function) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return CollectionUtils.distinct(collection, function, (object, object2) -> object);
    }

    public static <T, R> List<T> distinct(Collection<T> collection, Function<T, R> function, BinaryOperator<T> binaryOperator) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return new ArrayList(CollectionUtils.convertMap(collection, function, Function.identity(), binaryOperator).values());
    }

    public static <T, U> List<U> convertList(T[] TArray, Function<T, U> function) {
        if (ArrayUtil.isEmpty((Object[])TArray)) {
            return new ArrayList();
        }
        return CollectionUtils.convertList(Arrays.asList(TArray), function);
    }

    public static <T, U> List<U> convertList(Collection<T> collection, Function<T, U> function) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, U> List<U> convertList(Collection<T> collection, Function<T, U> function, Predicate<T> predicate) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().filter(predicate).map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, U> PageResult<U> convertPage(PageResult<T> pageResult, Function<T, U> function) {
        if (ArrayUtil.isEmpty(pageResult)) {
            return new PageResult(pageResult.getTotal());
        }
        return new PageResult<U>(CollectionUtils.convertList(pageResult.getList(), function), pageResult.getTotal());
    }

    public static <T, U> List<U> convertListByFlatMap(Collection<T> collection, Function<T, ? extends Stream<? extends U>> function) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().filter(Objects::nonNull).flatMap(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, U, R> List<R> convertListByFlatMap(Collection<T> collection, Function<? super T, ? extends U> function, Function<U, ? extends Stream<? extends R>> function2) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().map(function).filter(Objects::nonNull).flatMap(function2).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <K, V> List<V> mergeValuesFromMap(Map<K, List<V>> map) {
        return map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T> Set<T> convertSet(Collection<T> collection) {
        return CollectionUtils.convertSet(collection, object -> object);
    }

    public static <T, U> Set<U> convertSet(Collection<T> collection, Function<T, U> function) {
        if (CollUtil.isEmpty(collection)) {
            return new HashSet();
        }
        return collection.stream().map(function).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, U> Set<U> convertSet(Collection<T> collection, Function<T, U> function, Predicate<T> predicate) {
        if (CollUtil.isEmpty(collection)) {
            return new HashSet();
        }
        return collection.stream().filter(predicate).map(function).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, K> Map<K, T> convertMapByFilter(Collection<T> collection, Predicate<T> predicate, Function<T, K> function) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().filter(predicate).collect(Collectors.toMap(function, object -> object));
    }

    public static <T, U> Set<U> convertSetByFlatMap(Collection<T> collection, Function<T, ? extends Stream<? extends U>> function) {
        if (CollUtil.isEmpty(collection)) {
            return new HashSet();
        }
        return collection.stream().filter(Objects::nonNull).flatMap(function).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, U, R> Set<R> convertSetByFlatMap(Collection<T> collection, Function<? super T, ? extends U> function, Function<U, ? extends Stream<? extends R>> function2) {
        if (CollUtil.isEmpty(collection)) {
            return new HashSet();
        }
        return collection.stream().map(function).filter(Objects::nonNull).flatMap(function2).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, K> Map<K, T> convertMap(Collection<T> collection, Function<T, K> function) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return CollectionUtils.convertMap(collection, function, Function.identity());
    }

    public static <T, K> Map<K, T> convertMap(Collection<T> collection, Function<T, K> function, Supplier<? extends Map<K, T>> supplier) {
        if (CollUtil.isEmpty(collection)) {
            return supplier.get();
        }
        return CollectionUtils.convertMap(collection, function, Function.identity(), supplier);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return CollectionUtils.convertMap(collection, function, function2, (object, object2) -> object);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2, BinaryOperator<V> binaryOperator) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return CollectionUtils.convertMap(collection, function, function2, binaryOperator, HashMap::new);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2, Supplier<? extends Map<K, V>> supplier) {
        if (CollUtil.isEmpty(collection)) {
            return supplier.get();
        }
        return CollectionUtils.convertMap(collection, function, function2, (object, object2) -> object, supplier);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2, BinaryOperator<V> binaryOperator, Supplier<? extends Map<K, V>> supplier) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.toMap(function, function2, binaryOperator, supplier));
    }

    public static <T, K> Map<K, List<T>> convertMultiMap(Collection<T> collection, Function<T, K> function) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.groupingBy(function, Collectors.mapping(object -> object, Collectors.toList())));
    }

    public static <T, K, V> Map<K, List<V>> convertMultiMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.groupingBy(function, Collectors.mapping(function2, Collectors.toList())));
    }

    public static <T, K, V> Map<K, Set<V>> convertMultiMap2(Collection<T> collection, Function<T, K> function, Function<T, V> function2) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.groupingBy(function, Collectors.mapping(function2, Collectors.toSet())));
    }

    public static <T, K> Map<K, T> convertImmutableMap(Collection<T> collection, Function<T, K> function) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        collection.forEach(object -> builder.put(function.apply(object), object));
        return builder.build();
    }

    public static <T> List<List<T>> diffList(Collection<T> collection, Collection<T> collection2, BiFunction<T, T, Boolean> biFunction) {
        LinkedList<T> linkedList = new LinkedList<T>(collection2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<T> arrayList2 = new ArrayList<T>();
        for (T t : collection) {
            Object e = null;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!biFunction.apply(t, e2).booleanValue()) continue;
                iterator.remove();
                e = e2;
                break;
            }
            if (e != null) {
                arrayList.add(e);
                continue;
            }
            arrayList2.add(t);
        }
        return Arrays.asList(linkedList, arrayList, arrayList2);
    }

    public static boolean containsAny(Collection<?> collection, Collection<?> collection2) {
        return org.springframework.util.CollectionUtils.containsAny(collection, collection2);
    }

    public static <T> T getFirst(List<T> list) {
        return !CollectionUtil.isEmpty(list) ? (T)list.get(0) : null;
    }

    public static <T> T findFirst(Collection<T> collection, Predicate<T> predicate) {
        return CollectionUtils.findFirst(collection, predicate, Function.identity());
    }

    public static <T, U> U findFirst(Collection<T> collection, Predicate<T> predicate, Function<T, U> function) {
        if (CollUtil.isEmpty(collection)) {
            return null;
        }
        return collection.stream().filter(predicate).findFirst().map(function).orElse(null);
    }

    public static <T, V extends Comparable<? super V>> V getMaxValue(Collection<T> collection, Function<T, V> function) {
        if (CollUtil.isEmpty(collection)) {
            return null;
        }
        assert (!collection.isEmpty());
        T t = collection.stream().max(Comparator.comparing(function)).get();
        return (V)((Comparable)function.apply(t));
    }

    public static <T, V extends Comparable<? super V>> V getMinValue(List<T> list, Function<T, V> function) {
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        assert (list.size() > 0);
        Object e = list.stream().min(Comparator.comparing(function)).get();
        return (V)((Comparable)function.apply(e));
    }

    public static <T, V extends Comparable<? super V>> T getMinObject(List<T> list, Function<T, V> function) {
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        assert (list.size() > 0);
        return (T)list.stream().min(Comparator.comparing(function)).get();
    }

    public static <T, V extends Comparable<? super V>> V getSumValue(Collection<T> collection, Function<T, V> function, BinaryOperator<V> binaryOperator) {
        return CollectionUtils.getSumValue(collection, function, binaryOperator, null);
    }

    public static <T, V extends Comparable<? super V>> V getSumValue(Collection<T> collection, Function<T, V> function, BinaryOperator<V> binaryOperator, V v) {
        if (CollUtil.isEmpty(collection)) {
            return v;
        }
        assert (!collection.isEmpty());
        return (V)collection.stream().map(function).filter(Objects::nonNull).reduce(binaryOperator).orElse(v);
    }

    public static <T> void addIfNotNull(Collection<T> collection, T t) {
        if (t == null) {
            return;
        }
        collection.add(t);
    }

    public static <T> Collection<T> singleton(T t) {
        return t == null ? Collections.emptyList() : Collections.singleton(t);
    }

    public static <T> List<T> newArrayList(List<List<T>> list) {
        return list.stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

