/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.concurrent;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolUtils {
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolUtils.class);
    private static List<ExecutorService> executorServices = Lists.newArrayList();

    private ThreadPoolUtils() {
    }

    public static ExecutorService createThreadPool(String string) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(10, 10, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(string));
        executorServices.add(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ExecutorService createThreadPool(Integer n, String string) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor((int)n, (int)n, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(string));
        executorServices.add(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ExecutorService createThreadPool(String string, Integer n) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(10, 20, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(n), new DefaultThreadFactory(string));
        executorServices.add(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ExecutorService createThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, String string) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, blockingQueue, new DefaultThreadFactory(string));
        executorServices.add(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ExecutorService createThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, blockingQueue, threadFactory);
        executorServices.add(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ExecutorService createThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, blockingQueue, rejectedExecutionHandler);
        executorServices.add(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ExecutorService createThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
        executorServices.add(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(n);
        executorServices.add(scheduledThreadPoolExecutor);
        return scheduledThreadPoolExecutor;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n, ThreadFactory threadFactory) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(n, threadFactory);
        executorServices.add(scheduledThreadPoolExecutor);
        return scheduledThreadPoolExecutor;
    }

    public static void shutdown() {
        for (ExecutorService executorService : executorServices) {
            try {
                if (executorService.isShutdown()) continue;
                executorService.shutdown();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        logger.info("Success to close all user thread pool");
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String string) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + POOL_NUMBER.getAndIncrement() + "-" + string + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

