/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.date;

import cn.hutool.core.date.LocalDateTimeUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final String TIME_ZONE_DEFAULT = "GMT+8";
    public static final long SECOND_MILLIS = 1000L;
    public static final String FORMAT_YEAR_MONTH_DAY = "yyyy-MM-dd";
    public static final String FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY_MM_DDHHMM = "yyyy-MM-dd HH:mm";
    public static final String YYYYMMDDHHMMSS_CHINA = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final String YYYY_MM_DD_HHMMSSSSS = "yyyy-MM-dd HH:mm:ss,SSS";

    public static Date of(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        Instant instant = zonedDateTime.toInstant();
        return Date.from(instant);
    }

    public static LocalDateTime of(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static Date addTime(Duration duration) {
        return new Date(System.currentTimeMillis() + duration.toMillis());
    }

    public static boolean isExpired(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2 = LocalDateTime.now();
        return localDateTime2.isAfter(localDateTime);
    }

    public static Date buildTime(int n, int n2, int n3) {
        return DateUtils.buildTime(n, n2, n3, 0, 0, 0);
    }

    public static Date buildTime(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date max(Date date, Date date2) {
        if (date == null) {
            return date2;
        }
        if (date2 == null) {
            return date;
        }
        return date.compareTo(date2) > 0 ? date : date2;
    }

    public static LocalDateTime max(LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        if (localDateTime == null) {
            return localDateTime2;
        }
        if (localDateTime2 == null) {
            return localDateTime;
        }
        return localDateTime.isAfter(localDateTime2) ? localDateTime : localDateTime2;
    }

    public static boolean isToday(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.isSameDay((LocalDateTime)localDateTime, (LocalDateTime)LocalDateTime.now());
    }

    public static boolean isYesterday(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.isSameDay((LocalDateTime)localDateTime, (LocalDateTime)LocalDateTime.now().minusDays(1L));
    }

    public static Date now() {
        DateTime dateTime = new DateTime();
        return dateTime.toDate();
    }

    public static String now(String string) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)string);
        String string2 = dateTimeFormatter.print((ReadableInstant)new DateTime());
        return string2;
    }
}

