/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.encrypt;

import cn.hutool.core.codec.Base64;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RSAUtils.class);

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error("[generateKeyPair][\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25]", (Throwable)noSuchAlgorithmException);
            throw new RuntimeException("\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25", noSuchAlgorithmException);
        }
    }

    public static String getPublicKeyStr(KeyPair keyPair) {
        return Base64.encode((byte[])keyPair.getPublic().getEncoded());
    }

    public static String getPrivateKeyStr(KeyPair keyPair) {
        return Base64.encode((byte[])keyPair.getPrivate().getEncoded());
    }

    public static PublicKey getPublicKey(String string) {
        try {
            byte[] byArray = Base64.decode((CharSequence)string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            log.error("[getPublicKey][\u8fd8\u539f\u516c\u94a5\u5931\u8d25]", (Throwable)exception);
            throw new RuntimeException("\u8fd8\u539f\u516c\u94a5\u5931\u8d25", exception);
        }
    }

    public static PrivateKey getPrivateKey(String string) {
        try {
            byte[] byArray = Base64.decode((CharSequence)string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            log.error("[getPrivateKey][\u8fd8\u539f\u79c1\u94a5\u5931\u8d25]", (Throwable)exception);
            throw new RuntimeException("\u8fd8\u539f\u79c1\u94a5\u5931\u8d25", exception);
        }
    }

    public static String encrypt(String string, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return Base64.encode((byte[])cipher.doFinal(string.getBytes()));
        }
        catch (Exception exception) {
            log.error("[encrypt][RSA\u52a0\u5bc6\u5931\u8d25]", (Throwable)exception);
            throw new RuntimeException("RSA\u52a0\u5bc6\u5931\u8d25", exception);
        }
    }

    public static String decrypt(String string, PrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return new String(cipher.doFinal(Base64.decode((CharSequence)string)));
        }
        catch (Exception exception) {
            log.error("[decrypt][RSA\u89e3\u5bc6\u5931\u8d25]", (Throwable)exception);
            throw new RuntimeException("RSA\u89e3\u5bc6\u5931\u8d25", exception);
        }
    }

    public static boolean isEmpty(String string) {
        return StringUtils.isBlank((CharSequence)string);
    }
}

