/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.http;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.map.TableMap;
import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpUtils {
    public static String encodeUtf8(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8);
    }

    public static String replaceUrlQuery(String string, String string2, String string3) {
        UrlBuilder urlBuilder = UrlBuilder.of((String)string, (Charset)Charset.defaultCharset());
        TableMap tableMap = (TableMap)ReflectUtil.getFieldValue((Object)urlBuilder.getQuery(), (String)"query");
        tableMap.remove((Object)string2);
        urlBuilder.addQuery(string2, (Object)string3);
        return urlBuilder.build();
    }

    private String append(String string, Map<String, ?> map, boolean bl) {
        return HttpUtils.append(string, map, null, bl);
    }

    public static String append(String string, Map<String, ?> map, Map<String, String> map2, boolean bl) {
        URI uRI;
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.newInstance();
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromUriString((String)string);
        try {
            uRI = uriComponentsBuilder2.build(true).toUri();
        }
        catch (Exception exception) {
            uRI = uriComponentsBuilder2.build().toUri();
            uriComponentsBuilder2 = UriComponentsBuilder.fromUri((URI)uRI);
        }
        uriComponentsBuilder.scheme(uRI.getScheme()).port(uRI.getPort()).host(uRI.getHost()).userInfo(uRI.getUserInfo()).path(uRI.getPath());
        if (bl) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            if (uRI.getFragment() != null) {
                object = uRI.getFragment();
                stringBuilder.append((String)object);
            }
            for (String string2 : map.keySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                String string3 = string2;
                if (map2 != null && map2.containsKey(string2)) {
                    string3 = map2.get(string2);
                }
                stringBuilder.append(string3).append("={").append(string2).append("}");
            }
            if (stringBuilder.length() > 0) {
                uriComponentsBuilder.fragment(stringBuilder.toString());
            }
            object = uriComponentsBuilder.build().expand(map).encode();
            uriComponentsBuilder2.fragment(object.getFragment());
        } else {
            UriComponents uriComponents = map.keySet().iterator();
            while (uriComponents.hasNext()) {
                String string4;
                String string5 = string4 = uriComponents.next();
                if (map2 != null && map2.containsKey(string4)) {
                    string5 = map2.get(string4);
                }
                uriComponentsBuilder.queryParam(string5, new Object[]{"{" + string4 + "}"});
            }
            uriComponentsBuilder.fragment(uRI.getFragment());
            uriComponents = uriComponentsBuilder.build().expand(map).encode();
            uriComponentsBuilder2.query(uriComponents.getQuery());
        }
        return uriComponentsBuilder2.build().toUriString();
    }

    public static String[] obtainBasicAuthorization(HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        String string3 = httpServletRequest.getHeader("Authorization");
        if (StringUtils.hasText((String)(string3 = StrUtil.subAfter((CharSequence)string3, (CharSequence)"Basic ", (boolean)true)))) {
            string3 = Base64.decodeStr((CharSequence)string3);
            string2 = StrUtil.subBefore((CharSequence)string3, (CharSequence)":", (boolean)false);
            string = StrUtil.subAfter((CharSequence)string3, (CharSequence)":", (boolean)false);
        } else {
            string2 = httpServletRequest.getParameter("client_id");
            string = httpServletRequest.getParameter("client_secret");
        }
        if (StrUtil.isNotEmpty((CharSequence)string2) && StrUtil.isNotEmpty((CharSequence)string)) {
            return new String[]{string2, string};
        }
        return null;
    }

    public static String post(String string, Map<String, String> map, String string2) {
        try (HttpResponse httpResponse = ((HttpRequest)HttpRequest.post((String)string).addHeaders(map)).body(string2).execute();){
            String string3 = httpResponse.body();
            return string3;
        }
    }

    public static String get(String string, Map<String, String> map) {
        try (HttpResponse httpResponse = ((HttpRequest)HttpRequest.get((String)string).addHeaders(map)).execute();){
            String string2 = httpResponse.body();
            return string2;
        }
    }
}

