/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.json;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static void init(ObjectMapper objectMapper) {
        JsonUtils.objectMapper = objectMapper;
    }

    public static String toJsonString(Object object) {
        return objectMapper.writeValueAsString(object);
    }

    public static byte[] toJsonByte(Object object) {
        return objectMapper.writeValueAsBytes(object);
    }

    public static String toJsonPrettyString(Object object) {
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    public static <T> T parseObject(String string, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(string, clazz);
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)string, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static <T> T parseObject(String string, String string2, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            JsonNode jsonNode = objectMapper.readTree(string);
            JsonNode jsonNode2 = jsonNode.path(string2);
            return (T)objectMapper.readValue(jsonNode2.toString(), clazz);
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)string, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static <T> T parseObject(String string, Type type) {
        if (StrUtil.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(string, objectMapper.getTypeFactory().constructType(type));
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)string, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static <T> T parseObject2(String string, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)string)) {
            return null;
        }
        return (T)JSONUtil.toBean((String)string, clazz);
    }

    public static <T> T parseObject(byte[] byArray, Class<T> clazz) {
        if (ArrayUtil.isEmpty((byte[])byArray)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(byArray, clazz);
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)byArray, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static <T> T parseObject(String string, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(string, typeReference);
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)string, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static <T> T parseObjectQuietly(String string, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(string, typeReference);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T> List<T> parseArray(String string, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)string)) {
            return new ArrayList();
        }
        try {
            return (List)objectMapper.readValue(string, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)string, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static <T> List<T> parseArray(String string, String string2, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            JsonNode jsonNode = objectMapper.readTree(string);
            JsonNode jsonNode2 = jsonNode.path(string2);
            return (List)objectMapper.readValue(jsonNode2.toString(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)string, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static JsonNode parseTree(String string) {
        try {
            return objectMapper.readTree(string);
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)string, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static JsonNode parseTree(byte[] byArray) {
        try {
            return objectMapper.readTree(byArray);
        }
        catch (IOException iOException) {
            log.error("json parse err,json:{}", (Object)byArray, (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static boolean isJson(String string) {
        return JSONUtil.isTypeJSON((String)string);
    }

    public static boolean isJsonObject(String string) {
        return JSONUtil.isTypeJSONObject((String)string);
    }

    static {
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModules(new Module[]{new JavaTimeModule()});
    }
}

