/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.number;

import cn.hutool.core.math.Money;
import cn.hutool.core.util.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MoneyUtils {
    private static final int PRICE_SCALE = 2;
    public static final BigDecimal PERCENT_100 = BigDecimal.valueOf(100L);

    public static Integer calculateRatePrice(Integer n, Double d) {
        return MoneyUtils.calculateRatePrice(n, d, 0, RoundingMode.HALF_UP).intValue();
    }

    public static Integer calculateRatePriceFloor(Integer n, Double d) {
        return MoneyUtils.calculateRatePrice(n, d, 0, RoundingMode.FLOOR).intValue();
    }

    public static Integer calculator(Integer n, Integer n2, Integer n3) {
        n = n * n2;
        if (n3 == null) {
            return n;
        }
        return MoneyUtils.calculateRatePriceFloor(n, Double.valueOf(n3 / 100));
    }

    public static BigDecimal calculateRatePrice(Number number, Number number2, int n, RoundingMode roundingMode) {
        return NumberUtil.toBigDecimal((Number)number).multiply(NumberUtil.toBigDecimal((Number)number2)).divide(BigDecimal.valueOf(100L), n, roundingMode);
    }

    public static BigDecimal fenToYuan(int n) {
        return new Money(0L, n).getAmount();
    }

    public static String fenToYuanStr(int n) {
        return new Money(0L, n).toString();
    }

    public static BigDecimal priceMultiply(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal == null || bigDecimal2 == null) {
            return null;
        }
        return bigDecimal.multiply(bigDecimal2).setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal priceMultiplyPercent(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal == null || bigDecimal2 == null) {
            return null;
        }
        return bigDecimal.multiply(bigDecimal2).divide(PERCENT_100, 2, RoundingMode.HALF_UP);
    }
}

