/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.object;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.lang.func.LambdaUtil;
import cn.hutool.core.util.ArrayUtil;
import com.lenovo.cloud.framework.common.pojo.PageParam;
import com.lenovo.cloud.framework.common.pojo.SortablePageParam;
import com.lenovo.cloud.framework.common.pojo.SortingField;
import java.util.Collections;
import org.springframework.util.Assert;

public class PageUtils {
    private static final Object[] ORDER_TYPES = new String[]{"asc", "desc"};

    public static int getStart(PageParam pageParam) {
        return (pageParam.getPageNo() - 1) * pageParam.getPageSize();
    }

    public static <T> SortingField buildSortingField(Func1<T, ?> func1) {
        return PageUtils.buildSortingField(func1, "desc");
    }

    public static <T> SortingField buildSortingField(Func1<T, ?> func1, String string) {
        Assert.isTrue((boolean)ArrayUtil.contains((Object[])ORDER_TYPES, (Object)string), (String)String.format("\u5b57\u6bb5\u7684\u6392\u5e8f\u7c7b\u578b\u53ea\u80fd\u662f %s/%s", ORDER_TYPES));
        String string2 = LambdaUtil.getFieldName(func1);
        return new SortingField(string2, string);
    }

    public static <T> void buildDefaultSortingField(SortablePageParam sortablePageParam, Func1<T, ?> func1) {
        if (sortablePageParam != null && CollUtil.isEmpty(sortablePageParam.getSortingFields())) {
            sortablePageParam.setSortingFields(Collections.singletonList(PageUtils.buildSortingField(func1)));
        }
    }
}

