/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.servlet;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static void writeJSON(HttpServletResponse httpServletResponse, Object object) {
        String string = JsonUtils.toJsonString(object);
        JakartaServletUtil.write((HttpServletResponse)httpServletResponse, (String)string, (String)"application/json;charset=UTF-8");
    }

    public static String getUserAgent(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("User-Agent");
        return string != null ? string : "";
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static String getUserAgent() {
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        return ServletUtils.getUserAgent(httpServletRequest);
    }

    public static String getClientIP() {
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        return JakartaServletUtil.getClientIP((HttpServletRequest)httpServletRequest, (String[])new String[0]);
    }

    public static boolean isJsonRequest(ServletRequest servletRequest) {
        return StrUtil.startWithIgnoreCase((CharSequence)servletRequest.getContentType(), (CharSequence)"application/json");
    }

    public static String getBody(HttpServletRequest httpServletRequest) {
        if (ServletUtils.isJsonRequest((ServletRequest)httpServletRequest)) {
            return JakartaServletUtil.getBody((ServletRequest)httpServletRequest);
        }
        return null;
    }

    public static byte[] getBodyBytes(HttpServletRequest httpServletRequest) {
        if (ServletUtils.isJsonRequest((ServletRequest)httpServletRequest)) {
            return JakartaServletUtil.getBodyBytes((ServletRequest)httpServletRequest);
        }
        return null;
    }

    public static String getClientIP(HttpServletRequest httpServletRequest) {
        return JakartaServletUtil.getClientIP((HttpServletRequest)httpServletRequest, (String[])new String[0]);
    }

    public static Map<String, String> getParamMap(HttpServletRequest httpServletRequest) {
        return JakartaServletUtil.getParamMap((ServletRequest)httpServletRequest);
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest httpServletRequest) {
        return JakartaServletUtil.getHeaderMap((HttpServletRequest)httpServletRequest);
    }
}

