/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.spring;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Flux;

public class CustomDevLoadBalancer
implements ServiceInstanceListSupplier {
    private final DiscoveryClient discoveryClient;

    public CustomDevLoadBalancer(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public String getServiceId() {
        return null;
    }

    public Flux<List<ServiceInstance>> get(Request request) {
        String string = this.extractServiceId(request);
        List list = this.discoveryClient.getInstances(string);
        if (list.isEmpty()) {
            return Flux.empty();
        }
        if (list.size() == 1) {
            return Flux.just((Object)list);
        }
        ServiceInstance serviceInstance2 = list.stream().filter(serviceInstance -> this.getLocalIpAddress().contains(serviceInstance.getHost())).findFirst().orElse(null);
        if (serviceInstance2 != null) {
            return Flux.just(List.of(serviceInstance2));
        }
        ServiceInstance serviceInstance3 = (ServiceInstance)list.get(new Random().nextInt(list.size()));
        return Flux.just(List.of(serviceInstance3));
    }

    public Flux<List<ServiceInstance>> get() {
        return null;
    }

    private String extractServiceId(Request request) {
        if (request.getContext() instanceof DefaultRequestContext) {
            Object object = ((DefaultRequestContext)request.getContext()).getClientRequest();
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof RequestData) {
                return ((RequestData)object).getUrl().getHost();
            }
        }
        return null;
    }

    private List<String> getLocalIpAddress() {
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    arrayList.add(inetAddress.getHostAddress());
                }
            }
            return arrayList;
        }
        catch (SocketException socketException) {
            throw new RuntimeException(socketException);
        }
    }
}

