/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.util.validation;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class ValidationUtils {
    private static final Pattern PATTERN_MOBILE = Pattern.compile("^(?:(?:\\+|00)86)?1(?:(?:3[\\d])|(?:4[0,1,4-9])|(?:5[0-3,5-9])|(?:6[2,5-7])|(?:7[0-8])|(?:8[\\d])|(?:9[0-3,5-9]))\\d{8}$");
    private static final Pattern PATTERN_URL = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    private static final Pattern PATTERN_XML_NCNAME = Pattern.compile("[a-zA-Z_][\\-_.0-9_a-zA-Z$]*");

    public static boolean isMobile(String string) {
        return StringUtils.hasText((String)string) && PATTERN_MOBILE.matcher(string).matches();
    }

    public static boolean isURL(String string) {
        return StringUtils.hasText((String)string) && PATTERN_URL.matcher(string).matches();
    }

    public static boolean isXmlNCName(String string) {
        return StringUtils.hasText((String)string) && PATTERN_XML_NCNAME.matcher(string).matches();
    }

    public static void validate(Object object, Class<?> ... classArray) {
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Assert.notNull((Object)validator);
        ValidationUtils.validate(validator, object, classArray);
    }

    public static void validate(Validator validator, Object object, Class<?> ... classArray) {
        Set set = validator.validate(object, (Class[])classArray);
        if (CollUtil.isNotEmpty((Collection)set)) {
            throw new ConstraintViolationException(set);
        }
    }
}

