/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.validation;

import cn.hutool.core.collection.CollUtil;
import com.lenovo.cloud.framework.common.core.ArrayValuable;
import com.lenovo.cloud.framework.common.validation.InEnum;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InEnumCollectionValidator
implements ConstraintValidator<InEnum, Collection<?>> {
    private List<?> values;

    public void initialize(InEnum inEnum) {
        ArrayValuable<?>[] arrayValuableArray = inEnum.value().getEnumConstants();
        this.values = arrayValuableArray.length == 0 ? Collections.emptyList() : Arrays.asList(arrayValuableArray[0].array());
    }

    public boolean isValid(Collection<?> collection, ConstraintValidatorContext constraintValidatorContext) {
        if (collection == null) {
            return true;
        }
        if (CollUtil.containsAll(this.values, collection)) {
            return true;
        }
        constraintValidatorContext.disableDefaultConstraintViolation();
        constraintValidatorContext.buildConstraintViolationWithTemplate(constraintValidatorContext.getDefaultConstraintMessageTemplate().replaceAll("\\{value}", CollUtil.join(collection, (CharSequence)","))).addConstraintViolation();
        return false;
    }
}

