/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.common.validation;

import com.lenovo.cloud.framework.common.core.ArrayValuable;
import com.lenovo.cloud.framework.common.validation.InEnum;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class InEnumValidator
implements ConstraintValidator<InEnum, Object> {
    private List<?> values;

    public void initialize(InEnum inEnum) {
        ArrayValuable<?>[] arrayValuableArray = inEnum.value().getEnumConstants();
        this.values = arrayValuableArray.length == 0 ? Collections.emptyList() : Arrays.asList(arrayValuableArray[0].array());
    }

    public boolean isValid(Object object, ConstraintValidatorContext constraintValidatorContext) {
        if (object == null) {
            return true;
        }
        if (this.values.contains(object)) {
            return true;
        }
        constraintValidatorContext.disableDefaultConstraintViolation();
        constraintValidatorContext.buildConstraintViolationWithTemplate(constraintValidatorContext.getDefaultConstraintMessageTemplate().replaceAll("\\{value}", this.values.toString())).addConstraintViolation();
        return false;
    }
}

