/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.gateway.filter.cors;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
public class CorsFilter
implements WebFilter {
    private static final String ALL = "*";
    private static final String MAX_AGE = "3600L";

    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        ServerHttpRequest serverHttpRequest = serverWebExchange.getRequest();
        if (!CorsUtils.isCorsRequest((ServerHttpRequest)serverHttpRequest)) {
            return webFilterChain.filter(serverWebExchange);
        }
        ServerHttpResponse serverHttpResponse = serverWebExchange.getResponse();
        HttpHeaders httpHeaders = serverHttpResponse.getHeaders();
        httpHeaders.add("Access-Control-Allow-Origin", ALL);
        httpHeaders.add("Access-Control-Allow-Methods", ALL);
        httpHeaders.add("Access-Control-Allow-Headers", ALL);
        httpHeaders.add("Access-Control-Max-Age", MAX_AGE);
        if (serverHttpRequest.getMethod() == HttpMethod.OPTIONS) {
            serverHttpResponse.setStatusCode((HttpStatusCode)HttpStatus.OK);
            return Mono.empty();
        }
        return webFilterChain.filter(serverWebExchange);
    }
}

