/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.gateway.filter.grey;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.nacos.balancer.NacosBalancer;
import com.lenovo.cloud.framework.common.util.collection.CollectionUtils;
import com.lenovo.cloud.gateway.util.EnvUtils;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.http.HttpHeaders;
import reactor.core.publisher.Mono;

public class GrayLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrayLoadBalancer.class);
    private static final String VERSION = "version";
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final String serviceId;

    public Mono<Response<ServiceInstance>> choose(Request request) {
        HttpHeaders httpHeaders = ((RequestDataContext)request.getContext()).getClientRequest().getHeaders();
        ServiceInstanceListSupplier serviceInstanceListSupplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return serviceInstanceListSupplier.get(request).next().map(list -> this.getInstanceResponse(list, httpHeaders));
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> list, HttpHeaders httpHeaders) {
        List list2;
        if (CollUtil.isEmpty(list)) {
            log.warn("[getInstanceResponse][serviceId({}) \u670d\u52a1\u5b9e\u4f8b\u5217\u8868\u4e3a\u7a7a]", (Object)this.serviceId);
            return new EmptyResponse();
        }
        String string = httpHeaders.getFirst(VERSION);
        if (StrUtil.isEmpty((CharSequence)string)) {
            list2 = list;
        } else {
            list2 = CollectionUtils.filterList(list, serviceInstance -> string.equals(serviceInstance.getMetadata().get(VERSION)));
            if (CollUtil.isEmpty((Collection)list2)) {
                log.warn("[getInstanceResponse][serviceId({}) \u6ca1\u6709\u6ee1\u8db3\u7248\u672c({})\u7684\u670d\u52a1\u5b9e\u4f8b\u5217\u8868\uff0c\u76f4\u63a5\u4f7f\u7528\u6240\u6709\u670d\u52a1\u5b9e\u4f8b\u5217\u8868]", (Object)this.serviceId, (Object)string);
                list2 = list;
            }
        }
        list2 = this.filterTagServiceInstances(list2, httpHeaders);
        return new DefaultResponse(NacosBalancer.getHostByRandomWeight3((List)list2));
    }

    private List<ServiceInstance> filterTagServiceInstances(List<ServiceInstance> list, HttpHeaders httpHeaders) {
        String string = EnvUtils.getTag((HttpHeaders)httpHeaders);
        if (StrUtil.isEmpty((CharSequence)string)) {
            return list;
        }
        List<ServiceInstance> list2 = CollectionUtils.filterList(list, serviceInstance -> string.equals(EnvUtils.getTag((ServiceInstance)serviceInstance)));
        if (CollUtil.isEmpty((Collection)list2)) {
            log.warn("[filterTagServiceInstances][serviceId({}) \u6ca1\u6709\u6ee1\u8db3 tag({}) \u7684\u670d\u52a1\u5b9e\u4f8b\u5217\u8868\uff0c\u76f4\u63a5\u4f7f\u7528\u6240\u6709\u670d\u52a1\u5b9e\u4f8b\u5217\u8868]", (Object)this.serviceId, (Object)string);
            list2 = list;
        }
        return list2;
    }

    @Generated
    public GrayLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> objectProvider, String string) {
        this.serviceInstanceListSupplierProvider = objectProvider;
        this.serviceId = string;
    }
}

