/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.gateway.filter.grey;

import com.lenovo.cloud.gateway.filter.grey.GrayLoadBalancer;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.gateway.config.GatewayLoadBalancerProperties;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.ReactiveLoadBalancerClientFilter;
import org.springframework.cloud.gateway.support.DelegatingServiceInstance;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class GrayReactiveLoadBalancerClientFilter
implements GlobalFilter,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrayReactiveLoadBalancerClientFilter.class);
    private final LoadBalancerClientFactory clientFactory;
    private final GatewayLoadBalancerProperties properties;

    public int getOrder() {
        return 10150;
    }

    public Mono<Void> filter(ServerWebExchange serverWebExchange, GatewayFilterChain gatewayFilterChain) {
        URI uRI = (URI)serverWebExchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String string = (String)serverWebExchange.getAttribute(ServerWebExchangeUtils.GATEWAY_SCHEME_PREFIX_ATTR);
        if (uRI == null || !"grayLb".equals(uRI.getScheme()) && !"grayLb".equals(string)) {
            return gatewayFilterChain.filter(serverWebExchange);
        }
        ServerWebExchangeUtils.addOriginalRequestUrl((ServerWebExchange)serverWebExchange, (URI)uRI);
        if (log.isTraceEnabled()) {
            log.trace(ReactiveLoadBalancerClientFilter.class.getSimpleName() + " url before: " + uRI);
        }
        URI uRI2 = (URI)serverWebExchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String string2 = uRI2.getHost();
        Set set = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors((Map)this.clientFactory.getInstances(string2, LoadBalancerLifecycle.class), RequestDataContext.class, ResponseData.class, ServiceInstance.class);
        DefaultRequest defaultRequest = new DefaultRequest((Object)new RequestDataContext(new RequestData(serverWebExchange.getRequest()), this.getHint(string2)));
        return this.choose((Request)defaultRequest, string2, set).doOnNext(response -> {
            String string2;
            if (!response.hasServer()) {
                set.forEach(loadBalancerLifecycle -> loadBalancerLifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, (Request)defaultRequest, response)));
                throw NotFoundException.create((boolean)this.properties.isUse404(), (String)("Unable to find instance for " + uRI.getHost()));
            }
            ServiceInstance serviceInstance = (ServiceInstance)response.getServer();
            URI uRI2 = serverWebExchange.getRequest().getURI();
            String string3 = string2 = serviceInstance.isSecure() ? "https" : "http";
            if (string != null) {
                string2 = uRI.getScheme();
            }
            DelegatingServiceInstance delegatingServiceInstance = new DelegatingServiceInstance(serviceInstance, string2);
            URI uRI3 = this.reconstructURI((ServiceInstance)delegatingServiceInstance, uRI2);
            if (log.isTraceEnabled()) {
                log.trace("LoadBalancerClientFilter url chosen: " + uRI3);
            }
            serverWebExchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uRI3);
            serverWebExchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR, response);
            set.forEach(loadBalancerLifecycle -> loadBalancerLifecycle.onStartRequest((Request)defaultRequest, response));
        }).then(gatewayFilterChain.filter(serverWebExchange)).doOnError(throwable -> set.forEach(loadBalancerLifecycle -> loadBalancerLifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, throwable, (Request)defaultRequest, (Response)serverWebExchange.getAttribute(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR))))).doOnSuccess(void_ -> set.forEach(loadBalancerLifecycle -> loadBalancerLifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, (Request)defaultRequest, (Response)serverWebExchange.getAttribute(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR), (Object)new ResponseData(serverWebExchange.getResponse(), new RequestData(serverWebExchange.getRequest()))))));
    }

    protected URI reconstructURI(ServiceInstance serviceInstance, URI uRI) {
        return LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)uRI);
    }

    private Mono<Response<ServiceInstance>> choose(Request<RequestDataContext> request, String string, Set<LoadBalancerLifecycle> set) {
        GrayLoadBalancer grayLoadBalancer = new GrayLoadBalancer(this.clientFactory.getLazyProvider(string, ServiceInstanceListSupplier.class), string);
        set.forEach(loadBalancerLifecycle -> loadBalancerLifecycle.onStart(request));
        return grayLoadBalancer.choose(request);
    }

    private String getHint(String string) {
        LoadBalancerProperties loadBalancerProperties = this.clientFactory.getProperties(string);
        Map map = loadBalancerProperties.getHint();
        String string2 = map.getOrDefault("default", "default");
        String string3 = (String)map.get(string);
        return string3 != null ? string3 : string2;
    }

    @Generated
    public GrayReactiveLoadBalancerClientFilter(LoadBalancerClientFactory loadBalancerClientFactory, GatewayLoadBalancerProperties gatewayLoadBalancerProperties) {
        this.clientFactory = loadBalancerClientFactory;
        this.properties = gatewayLoadBalancerProperties;
    }
}

