/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.gateway.filter.logging;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.gateway.filter.logging.AccessLog;
import com.lenovo.cloud.gateway.util.WebFrameworkUtils;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class AccessLogFilter
implements GlobalFilter,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessLogFilter.class);
    @Resource
    private CodecConfigurer codecConfigurer;

    private void writeAccessLog(AccessLog accessLog) {
        HashMap hashMap = MapUtil.newHashMap((int)15, (boolean)true);
        hashMap.put("userId", accessLog.getUserId());
        hashMap.put("userType", accessLog.getUserType());
        hashMap.put("routeId", accessLog.getRoute() != null ? accessLog.getRoute().getId() : null);
        hashMap.put("schema", accessLog.getSchema());
        hashMap.put("requestUrl", accessLog.getRequestUrl());
        hashMap.put("queryParams", accessLog.getQueryParams().toSingleValueMap());
        hashMap.put("requestBody", JsonUtils.isJson((String)accessLog.getRequestBody()) ? JSONUtil.parse((Object)accessLog.getRequestBody()) : accessLog.getRequestBody());
        hashMap.put("requestHeaders", JsonUtils.toJsonString((Object)accessLog.getRequestHeaders().toSingleValueMap()));
        hashMap.put("userIp", accessLog.getUserIp());
        hashMap.put("responseBody", JsonUtils.isJson((String)accessLog.getResponseBody()) ? JSONUtil.parse((Object)accessLog.getResponseBody()) : accessLog.getResponseBody());
        hashMap.put("responseHeaders", accessLog.getResponseHeaders() != null ? JsonUtils.toJsonString((Object)accessLog.getResponseHeaders().toSingleValueMap()) : null);
        hashMap.put("httpStatus", accessLog.getHttpStatus());
        hashMap.put("startTime", LocalDateTimeUtil.format((LocalDateTime)accessLog.getStartTime(), (DateTimeFormatter)DatePattern.NORM_DATETIME_MS_FORMATTER));
        hashMap.put("endTime", LocalDateTimeUtil.format((LocalDateTime)accessLog.getEndTime(), (DateTimeFormatter)DatePattern.NORM_DATETIME_MS_FORMATTER));
        hashMap.put("duration", accessLog.getDuration() != null ? accessLog.getDuration() + " ms" : null);
        log.info("[writeAccessLog][\u7f51\u5173\u65e5\u5fd7\uff1a{}]", (Object)JsonUtils.toJsonPrettyString((Object)hashMap));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Mono<Void> filter(ServerWebExchange serverWebExchange, GatewayFilterChain gatewayFilterChain) {
        ServerHttpRequest serverHttpRequest = serverWebExchange.getRequest();
        AccessLog accessLog = new AccessLog();
        accessLog.setRoute(WebFrameworkUtils.getGatewayRoute((ServerWebExchange)serverWebExchange));
        accessLog.setSchema(serverHttpRequest.getURI().getScheme());
        accessLog.setRequestMethod(serverHttpRequest.getMethod().name());
        accessLog.setRequestUrl(serverHttpRequest.getURI().getRawPath());
        accessLog.setQueryParams(serverHttpRequest.getQueryParams());
        accessLog.setRequestHeaders((MultiValueMap)serverHttpRequest.getHeaders());
        accessLog.setStartTime(LocalDateTime.now());
        accessLog.setUserIp(WebFrameworkUtils.getClientIP((ServerWebExchange)serverWebExchange, (String[])new String[0]));
        MediaType mediaType = serverHttpRequest.getHeaders().getContentType();
        if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType) || MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
            return this.filterWithRequestBody(serverWebExchange, gatewayFilterChain, accessLog);
        }
        return this.filterWithoutRequestBody(serverWebExchange, gatewayFilterChain, accessLog);
    }

    private Mono<Void> filterWithoutRequestBody(ServerWebExchange serverWebExchange, GatewayFilterChain gatewayFilterChain, AccessLog accessLog) {
        ServerHttpResponseDecorator serverHttpResponseDecorator = this.recordResponseLog(serverWebExchange, accessLog);
        return gatewayFilterChain.filter(serverWebExchange.mutate().response((ServerHttpResponse)serverHttpResponseDecorator).build()).then(Mono.fromRunnable(() -> this.writeAccessLog(accessLog)));
    }

    private Mono<Void> filterWithRequestBody(ServerWebExchange serverWebExchange, GatewayFilterChain gatewayFilterChain, AccessLog accessLog) {
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)serverWebExchange, (List)this.codecConfigurer.getReaders());
        Mono mono = serverRequest.bodyToMono(String.class).flatMap(string -> {
            accessLog.setRequestBody(string);
            return Mono.just((Object)string);
        });
        BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)mono, String.class);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.putAll((Map)serverWebExchange.getRequest().getHeaders());
        httpHeaders.remove((Object)"Content-Length");
        CachedBodyOutputMessage cachedBodyOutputMessage = new CachedBodyOutputMessage(serverWebExchange, httpHeaders);
        return bodyInserter.insert((ReactiveHttpOutputMessage)cachedBodyOutputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
            ServerHttpRequestDecorator serverHttpRequestDecorator = this.requestDecorate(serverWebExchange, httpHeaders, cachedBodyOutputMessage);
            ServerHttpResponseDecorator serverHttpResponseDecorator = this.recordResponseLog(serverWebExchange, accessLog);
            return gatewayFilterChain.filter(serverWebExchange.mutate().request((ServerHttpRequest)serverHttpRequestDecorator).response((ServerHttpResponse)serverHttpResponseDecorator).build()).then(Mono.fromRunnable(() -> this.writeAccessLog(accessLog)));
        }));
    }

    private ServerHttpResponseDecorator recordResponseLog(ServerWebExchange serverWebExchange, AccessLog accessLog) {
        ServerHttpResponse serverHttpResponse = serverWebExchange.getResponse();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private ServerHttpRequestDecorator requestDecorate(ServerWebExchange serverWebExchange, HttpHeaders httpHeaders, CachedBodyOutputMessage cachedBodyOutputMessage) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private byte[] readContent(List<? extends DataBuffer> list) {
        DefaultDataBufferFactory defaultDataBufferFactory = new DefaultDataBufferFactory();
        DataBuffer dataBuffer = defaultDataBufferFactory.join(list);
        byte[] byArray = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(byArray);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        return byArray;
    }
}

