/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.gateway.filter.security;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.lenovo.cloud.framework.common.core.KeyValue;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.framework.common.util.cache.CacheUtils;
import com.lenovo.cloud.framework.common.util.date.LocalDateTimeUtils;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.gateway.filter.security.LoginUser;
import com.lenovo.cloud.gateway.util.SecurityFrameworkUtils;
import com.lenovo.cloud.gateway.util.WebFrameworkUtils;
import com.lenovo.cloud.module.system.api.oauth2.dto.OAuth2AccessTokenCheckRespDTO;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class TokenAuthenticationFilter
implements GlobalFilter,
Ordered {
    private static final TypeReference<CommonResult<OAuth2AccessTokenCheckRespDTO>> CHECK_RESULT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final LoginUser LOGIN_USER_EMPTY = new LoginUser();
    private final WebClient webClient;
    private final LoadingCache<KeyValue<Long, String>, LoginUser> loginUserCache = CacheUtils.buildAsyncReloadingCache((Duration)Duration.ofMinutes(1L), (CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    public TokenAuthenticationFilter(ReactorLoadBalancerExchangeFilterFunction reactorLoadBalancerExchangeFilterFunction) {
        this.webClient = WebClient.builder().filter((ExchangeFilterFunction)reactorLoadBalancerExchangeFilterFunction).build();
    }

    public Mono<Void> filter(ServerWebExchange serverWebExchange, GatewayFilterChain gatewayFilterChain) {
        SecurityFrameworkUtils.removeLoginUser((ServerWebExchange)serverWebExchange);
        String string = SecurityFrameworkUtils.obtainAuthorization((ServerWebExchange)serverWebExchange);
        if (StrUtil.isEmpty((CharSequence)string)) {
            return gatewayFilterChain.filter(serverWebExchange);
        }
        return this.getLoginUser(serverWebExchange, string).defaultIfEmpty((Object)LOGIN_USER_EMPTY).flatMap(loginUser -> {
            if (loginUser == LOGIN_USER_EMPTY || loginUser.getExpiresTime() == null || LocalDateTimeUtils.beforeNow((LocalDateTime)loginUser.getExpiresTime())) {
                return gatewayFilterChain.filter(serverWebExchange);
            }
            SecurityFrameworkUtils.setLoginUser((ServerWebExchange)serverWebExchange, (LoginUser)loginUser);
            ServerWebExchange serverWebExchange2 = serverWebExchange.mutate().request(builder -> SecurityFrameworkUtils.setLoginUserHeader((ServerHttpRequest.Builder)builder, (LoginUser)loginUser)).build();
            return gatewayFilterChain.filter(serverWebExchange2);
        });
    }

    private Mono<LoginUser> getLoginUser(ServerWebExchange serverWebExchange, String string2) {
        Long l = WebFrameworkUtils.getTenantId((ServerWebExchange)serverWebExchange);
        KeyValue keyValue = new KeyValue().setKey((Object)l).setValue((Object)string2);
        LoginUser loginUser = (LoginUser)this.loginUserCache.getIfPresent((Object)keyValue);
        if (loginUser != null) {
            return Mono.just((Object)loginUser);
        }
        return this.checkAccessToken(l, string2).flatMap(string -> {
            LoginUser loginUser = this.buildUser(string);
            if (loginUser != null) {
                this.loginUserCache.put((Object)keyValue, (Object)loginUser);
                return Mono.just((Object)loginUser);
            }
            return Mono.empty();
        });
    }

    private Mono<String> checkAccessToken(Long l, String string) {
        return this.webClient.get().uri("http://system-server/rpc-api/system/oauth2/token/check", uriBuilder -> uriBuilder.queryParam("accessToken", new Object[]{string}).build(new Object[0])).headers(httpHeaders -> WebFrameworkUtils.setTenantIdHeader((Long)l, (HttpHeaders)httpHeaders)).retrieve().bodyToMono(String.class);
    }

    private LoginUser buildUser(String string) {
        CommonResult commonResult = (CommonResult)JsonUtils.parseObject((String)string, (TypeReference)CHECK_RESULT_TYPE_REFERENCE);
        if (commonResult == null) {
            return null;
        }
        if (commonResult.isError()) {
            if (Objects.equals(commonResult.getCode(), HttpStatus.UNAUTHORIZED.value())) {
                return LOGIN_USER_EMPTY;
            }
            return null;
        }
        OAuth2AccessTokenCheckRespDTO oAuth2AccessTokenCheckRespDTO = (OAuth2AccessTokenCheckRespDTO)commonResult.getData();
        return new LoginUser().setId(oAuth2AccessTokenCheckRespDTO.getUserId()).setUserType(oAuth2AccessTokenCheckRespDTO.getUserType()).setInfo(oAuth2AccessTokenCheckRespDTO.getUserInfo()).setTenantId(oAuth2AccessTokenCheckRespDTO.getTenantId()).setScopes(oAuth2AccessTokenCheckRespDTO.getScopes()).setExpiresTime(oAuth2AccessTokenCheckRespDTO.getExpiresTime());
    }

    public int getOrder() {
        return -100;
    }
}

