/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.gateway.handler;

import com.lenovo.cloud.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.gateway.util.WebFrameworkUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
@Order(value=-1)
public class GlobalExceptionHandler
implements ErrorWebExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    public Mono<Void> handle(ServerWebExchange serverWebExchange, Throwable throwable) {
        ServerHttpResponse serverHttpResponse = serverWebExchange.getResponse();
        if (serverHttpResponse.isCommitted()) {
            return Mono.error((Throwable)throwable);
        }
        CommonResult commonResult = throwable instanceof ResponseStatusException ? this.responseStatusExceptionHandler(serverWebExchange, (ResponseStatusException)throwable) : this.defaultExceptionHandler(serverWebExchange, throwable);
        return WebFrameworkUtils.writeJSON((ServerWebExchange)serverWebExchange, (Object)commonResult);
    }

    private CommonResult<?> responseStatusExceptionHandler(ServerWebExchange serverWebExchange, ResponseStatusException responseStatusException) {
        ServerHttpRequest serverHttpRequest = serverWebExchange.getRequest();
        log.error("[responseStatusExceptionHandler][uri({}/{}) \u53d1\u751f\u5f02\u5e38]", new Object[]{serverHttpRequest.getURI(), serverHttpRequest.getMethod(), responseStatusException});
        return CommonResult.error((Integer)responseStatusException.getStatusCode().value(), (String)responseStatusException.getReason());
    }

    @ExceptionHandler(value={Exception.class})
    public CommonResult<?> defaultExceptionHandler(ServerWebExchange serverWebExchange, Throwable throwable) {
        ServerHttpRequest serverHttpRequest = serverWebExchange.getRequest();
        log.error("[defaultExceptionHandler][uri({}/{}) \u53d1\u751f\u5f02\u5e38]", new Object[]{serverHttpRequest.getURI(), serverHttpRequest.getMethod(), throwable});
        return CommonResult.error((Integer)GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode(), (String)GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getMsg());
    }
}

