/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.gateway.util;

import cn.hutool.core.map.MapUtil;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.gateway.filter.security.LoginUser;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class SecurityFrameworkUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityFrameworkUtils.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_BEARER = "Bearer";
    private static final String LOGIN_USER_HEADER = "login-user";
    private static final String LOGIN_USER_ID_ATTR = "login-user-id";
    private static final String LOGIN_USER_TYPE_ATTR = "login-user-type";

    private SecurityFrameworkUtils() {
    }

    public static String obtainAuthorization(ServerWebExchange serverWebExchange) {
        String string = serverWebExchange.getRequest().getHeaders().getFirst(AUTHORIZATION_HEADER);
        if (!StringUtils.hasText((String)string)) {
            return null;
        }
        int n = string.indexOf("Bearer ");
        if (n == -1) {
            return null;
        }
        return string.substring(n + 7).trim();
    }

    public static void setLoginUser(ServerWebExchange serverWebExchange, LoginUser loginUser) {
        serverWebExchange.getAttributes().put(LOGIN_USER_ID_ATTR, loginUser.getId());
        serverWebExchange.getAttributes().put(LOGIN_USER_TYPE_ATTR, loginUser.getUserType());
    }

    public static ServerWebExchange removeLoginUser(ServerWebExchange serverWebExchange) {
        if (!serverWebExchange.getRequest().getHeaders().containsKey((Object)LOGIN_USER_HEADER)) {
            return serverWebExchange;
        }
        ServerHttpRequest serverHttpRequest = serverWebExchange.getRequest().mutate().headers(httpHeaders -> httpHeaders.remove((Object)LOGIN_USER_HEADER)).build();
        return serverWebExchange.mutate().request(serverHttpRequest).build();
    }

    public static Long getLoginUserId(ServerWebExchange serverWebExchange) {
        return MapUtil.getLong((Map)serverWebExchange.getAttributes(), (Object)LOGIN_USER_ID_ATTR);
    }

    public static Integer getLoginUserType(ServerWebExchange serverWebExchange) {
        return MapUtil.getInt((Map)serverWebExchange.getAttributes(), (Object)LOGIN_USER_TYPE_ATTR);
    }

    public static void setLoginUserHeader(ServerHttpRequest.Builder builder, LoginUser loginUser) {
        try {
            String string = JsonUtils.toJsonString((Object)loginUser);
            string = URLEncoder.encode(string, StandardCharsets.UTF_8);
            builder.header(LOGIN_USER_HEADER, new String[]{string});
        }
        catch (Exception exception) {
            log.error("[setLoginUserHeader][\u5e8f\u5217\u5316 user({}) \u53d1\u751f\u5f02\u5e38]", (Object)loginUser, (Object)exception);
            throw exception;
        }
    }
}

