/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.gateway.util;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebFrameworkUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebFrameworkUtils.class);
    private static final String HEADER_TENANT_ID = "tenant-id";

    private WebFrameworkUtils() {
    }

    public static void setTenantIdHeader(Long l, HttpHeaders httpHeaders) {
        if (l == null) {
            return;
        }
        httpHeaders.set(HEADER_TENANT_ID, String.valueOf(l));
    }

    public static Long getTenantId(ServerWebExchange serverWebExchange) {
        String string = serverWebExchange.getRequest().getHeaders().getFirst(HEADER_TENANT_ID);
        return NumberUtil.isNumber((CharSequence)string) ? Long.valueOf(string) : null;
    }

    public static Mono<Void> writeJSON(ServerWebExchange serverWebExchange, Object object) {
        ServerHttpResponse serverHttpResponse = serverWebExchange.getResponse();
        serverHttpResponse.getHeaders().setContentType(MediaType.APPLICATION_JSON_UTF8);
        return serverHttpResponse.writeWith((Publisher)Mono.fromSupplier(() -> {
            DataBufferFactory dataBufferFactory = serverHttpResponse.bufferFactory();
            try {
                return dataBufferFactory.wrap(JsonUtils.toJsonByte((Object)object));
            }
            catch (Exception exception) {
                ServerHttpRequest serverHttpRequest = serverWebExchange.getRequest();
                log.error("[writeJSON][uri({}/{}) \u53d1\u751f\u5f02\u5e38]", new Object[]{serverHttpRequest.getURI(), serverHttpRequest.getMethod(), exception});
                return dataBufferFactory.wrap(new byte[0]);
            }
        }));
    }

    public static String getClientIP(ServerWebExchange serverWebExchange, String ... stringArray) {
        String string;
        String[] stringArray2 = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])stringArray)) {
            stringArray2 = (String[])ArrayUtil.addAll((Object[][])new String[][]{stringArray2, stringArray});
        }
        for (String string2 : stringArray2) {
            string = serverWebExchange.getRequest().getHeaders().getFirst(string2);
            if (NetUtil.isUnknown((String)string)) continue;
            return NetUtil.getMultistageReverseProxyIp((String)string);
        }
        if (serverWebExchange.getRequest().getRemoteAddress() == null) {
            return null;
        }
        string = serverWebExchange.getRequest().getRemoteAddress().getHostString();
        return NetUtil.getMultistageReverseProxyIp((String)string);
    }

    public static Route getGatewayRoute(ServerWebExchange serverWebExchange) {
        return (Route)serverWebExchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
    }
}

