/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.module.system.api.dict;

import cn.hutool.core.util.ObjUtil;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.framework.common.util.collection.CollectionUtils;
import com.lenovo.cloud.module.system.api.dict.dto.DictDataRespDTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="system-server")
@Tag(name="RPC \u670d\u52a1 - \u5b57\u5178\u6570\u636e")
public interface DictDataApi {
    public static final String PREFIX = "/rpc-api/system/dict-data";

    @GetMapping(value={"/rpc-api/system/dict-data/valid"})
    @Operation(summary="\u6821\u9a8c\u5b57\u5178\u6570\u636e\u4eec\u662f\u5426\u6709\u6548")
    @Parameters(value={@Parameter(name="dictType", description="\u5b57\u5178\u7c7b\u578b", example="SEX", required=true), @Parameter(name="descriptions", description="\u5b57\u5178\u6570\u636e\u503c\u7684\u6570\u7ec4", example="1,2", required=true)})
    public CommonResult<Boolean> validateDictDataList(@RequestParam(value="dictType") String var1, @RequestParam(value="values") Collection<String> var2);

    @GetMapping(value={"/rpc-api/system/dict-data/get"})
    @Operation(summary="\u83b7\u5f97\u6307\u5b9a\u7684\u5b57\u5178\u6570\u636e")
    @Parameters(value={@Parameter(name="dictType", description="\u5b57\u5178\u7c7b\u578b", example="SEX", required=true), @Parameter(name="description", description="\u5b57\u5178\u6570\u636e\u503c", example="1", required=true)})
    public CommonResult<DictDataRespDTO> getDictData(@RequestParam(value="dictType") String var1, @RequestParam(value="value") String var2);

    default public String getDictDataLabel(String string, Integer n) {
        DictDataRespDTO dictDataRespDTO = (DictDataRespDTO)this.getDictData(string, String.valueOf(n)).getData();
        if (ObjUtil.isNull((Object)dictDataRespDTO)) {
            return "";
        }
        return dictDataRespDTO.getLabel();
    }

    @GetMapping(value={"/rpc-api/system/dict-data/parse"})
    @Operation(summary="\u89e3\u6790\u83b7\u5f97\u6307\u5b9a\u7684\u5b57\u5178\u6570\u636e")
    @Parameters(value={@Parameter(name="dictType", description="\u5b57\u5178\u7c7b\u578b", example="SEX", required=true), @Parameter(name="label", description="\u5b57\u5178\u6807\u7b7e", example="\u7537", required=true)})
    public CommonResult<DictDataRespDTO> parseDictData(@RequestParam(value="dictType") String var1, @RequestParam(value="label") String var2);

    @GetMapping(value={"/rpc-api/system/dict-data/list"})
    @Operation(summary="\u83b7\u5f97\u6307\u5b9a\u5b57\u5178\u7c7b\u578b\u7684\u5b57\u5178\u6570\u636e\u5217\u8868")
    @Parameter(name="dictType", description="\u5b57\u5178\u7c7b\u578b", example="SEX", required=true)
    public CommonResult<List<DictDataRespDTO>> getDictDataList(@RequestParam(value="dictType") String var1);

    default public List<String> getDictDataLabelList(String string) {
        List list = (List)this.getDictDataList(string).getData();
        return CollectionUtils.convertList((Collection)list, DictDataRespDTO::getLabel);
    }
}

