/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.refresh.NacosContextRefresher;
import com.alibaba.cloud.nacos.refresh.NacosRefreshHistory;
import com.alibaba.cloud.nacos.refresh.SmartConfigurationPropertiesRebinder;
import com.alibaba.cloud.nacos.refresh.condition.ConditionalOnNonDefaultBehavior;
import com.lenovo.cloud.framework.jasypt.constant.JasyptConstants;
import com.lenovo.cloud.framework.jasypt.util.JasyptNacosUtils;
import com.lenovo.cloud.framework.jasypt.util.JasyptUtils;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.nacos.config.enabled"}, matchIfMissing=true)
public class NacosConfigAutoConfiguration {
    private final ConfigurableEnvironment environment;

    public NacosConfigAutoConfiguration(ConfigurableEnvironment configurableEnvironment) {
        this.environment = configurableEnvironment;
    }

    @Bean
    @ConditionalOnMissingBean(value={NacosConfigProperties.class}, search=SearchStrategy.CURRENT)
    public NacosConfigProperties nacosConfigProperties(ApplicationContext applicationContext) {
        if (applicationContext.getParent() != null && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)applicationContext.getParent(), NacosConfigProperties.class).length > 0) {
            return (NacosConfigProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)applicationContext.getParent(), NacosConfigProperties.class);
        }
        NacosConfigProperties nacosConfigProperties = new NacosConfigProperties();
        StandardPBEStringEncryptor standardPBEStringEncryptor = JasyptUtils.getEncryptorFromEnvironment((ConfigurableEnvironment)this.environment);
        if (standardPBEStringEncryptor != null) {
            JasyptNacosUtils.processEnvironment((ConfigurableEnvironment)this.environment, (StandardPBEStringEncryptor)standardPBEStringEncryptor);
            this.setNacosPropertiesFromSystemProperties(nacosConfigProperties);
        }
        return nacosConfigProperties;
    }

    @Bean
    public NacosRefreshHistory nacosRefreshHistory() {
        return new NacosRefreshHistory();
    }

    @Bean
    public NacosConfigManager nacosConfigManager(NacosConfigProperties nacosConfigProperties) {
        return new NacosConfigManager(nacosConfigProperties, this.environment);
    }

    @Bean
    public NacosContextRefresher nacosContextRefresher(NacosConfigManager nacosConfigManager, NacosRefreshHistory nacosRefreshHistory) {
        return new NacosContextRefresher(nacosConfigManager, nacosRefreshHistory);
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    @ConditionalOnNonDefaultBehavior
    public ConfigurationPropertiesRebinder smartConfigurationPropertiesRebinder(ConfigurationPropertiesBeans configurationPropertiesBeans) {
        return new SmartConfigurationPropertiesRebinder(configurationPropertiesBeans);
    }

    private void setNacosPropertiesFromSystemProperties(NacosConfigProperties nacosConfigProperties) {
        for (String string : JasyptConstants.NACOS_PROPERTY_PREFIXES) {
            String string2 = System.getProperty(string);
            if (string2 == null || string2.isEmpty()) continue;
            if (string.endsWith("username")) {
                nacosConfigProperties.setUsername(string2);
                continue;
            }
            if (!string.endsWith("password")) continue;
            nacosConfigProperties.setPassword(string2);
        }
    }
}

