/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.diagnostics.analyzer.NacosConnectionFailureException;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.lenovo.cloud.framework.jasypt.constant.JasyptConstants;
import com.lenovo.cloud.framework.jasypt.util.JasyptNacosUtils;
import com.lenovo.cloud.framework.jasypt.util.JasyptUtils;
import java.util.Objects;
import java.util.Properties;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosConfigManager {
    private static final Logger log = LoggerFactory.getLogger(NacosConfigManager.class);
    private static ConfigService service = null;
    private NacosConfigProperties nacosConfigProperties;
    private ConfigurableEnvironment environment;

    public NacosConfigManager(NacosConfigProperties nacosConfigProperties, ConfigurableEnvironment configurableEnvironment) {
        this.nacosConfigProperties = nacosConfigProperties;
        this.environment = configurableEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ConfigService createConfigService(NacosConfigProperties nacosConfigProperties) {
        if (!Objects.isNull(service)) return service;
        Class<NacosConfigManager> clazz = NacosConfigManager.class;
        synchronized (NacosConfigManager.class) {
            try {
                if (!Objects.isNull(service)) return service;
                service = NacosFactory.createConfigService((Properties)nacosConfigProperties.assembleConfigServiceProperties());
            }
            catch (NacosException nacosException) {
                log.error(nacosException.getMessage());
                throw new NacosConnectionFailureException(nacosConfigProperties.getServerAddr(), nacosException.getMessage(), nacosException);
            }
            return service;
        }
    }

    public ConfigService getConfigService() {
        NacosConfigProperties nacosConfigProperties = this.nacosConfigProperties;
        StandardPBEStringEncryptor standardPBEStringEncryptor = JasyptUtils.getEncryptorFromEnvironment((ConfigurableEnvironment)this.environment);
        if (standardPBEStringEncryptor != null) {
            JasyptNacosUtils.processEnvironment((ConfigurableEnvironment)this.environment, (StandardPBEStringEncryptor)standardPBEStringEncryptor);
            this.setNacosPropertiesFromSystemProperties(nacosConfigProperties);
        }
        return NacosConfigManager.createConfigService(nacosConfigProperties);
    }

    public NacosConfigProperties getNacosConfigProperties() {
        return this.nacosConfigProperties;
    }

    private void setNacosPropertiesFromSystemProperties(NacosConfigProperties nacosConfigProperties) {
        for (String string : JasyptConstants.NACOS_PROPERTY_PREFIXES) {
            String string2 = System.getProperty(string);
            if (string2 == null || string2.isEmpty()) continue;
            if (string.endsWith("username")) {
                nacosConfigProperties.setUsername(string2);
                continue;
            }
            if (!string.endsWith("password")) continue;
            nacosConfigProperties.setPassword(string2);
        }
    }
}

