/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.spring.util.PropertySourcesUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@ConfigurationProperties(value="spring.cloud.nacos.config")
public class NacosConfigProperties {
    public static final String PREFIX = "spring.cloud.nacos.config";
    public static final String COMMAS = ",";
    public static final String SEPARATOR = "[,]";
    public static final String DEFAULT_NAMESPACE = "public";
    public static final String DEFAULT_ADDRESS = "127.0.0.1:8848";
    private static final Pattern PATTERN = Pattern.compile("-(\\w)");
    private static final Logger log = LoggerFactory.getLogger(NacosConfigProperties.class);
    @Autowired
    @JsonIgnore
    private Environment environment;
    private String serverAddr;
    private String username;
    private String password;
    private String encode;
    private String group = "DEFAULT_GROUP";
    private String prefix;
    private String fileExtension = "properties";
    private int timeout = 3000;
    private String maxRetry;
    private String configLongPollTimeout;
    private String configRetryTime;
    private boolean enableRemoteSyncConfig = false;
    private String endpoint;
    private String namespace;
    private String accessKey;
    private String secretKey;
    private String ramRoleName;
    private String contextPath;
    private String clusterName;
    private String name;
    private List<Config> sharedConfigs;
    private List<Config> extensionConfigs;
    private boolean refreshEnabled = true;

    @PostConstruct
    public void init() {
        this.overrideFromEnv();
    }

    private void overrideFromEnv() {
        if (this.environment == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.getServerAddr())) {
            String string = this.environment.resolvePlaceholders("${spring.cloud.nacos.config.server-addr:}");
            if (StringUtils.isEmpty((CharSequence)string)) {
                string = this.environment.resolvePlaceholders("${spring.cloud.nacos.server-addr:127.0.0.1:8848}");
            }
            this.setServerAddr(string);
        }
        if (StringUtils.isEmpty((CharSequence)this.getUsername())) {
            this.setUsername(this.environment.resolvePlaceholders("${spring.cloud.nacos.username:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getPassword())) {
            this.setPassword(this.environment.resolvePlaceholders("${spring.cloud.nacos.password:}"));
        }
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String string) {
        this.serverAddr = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String string) {
        this.fileExtension = string;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public String getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(String string) {
        this.maxRetry = string;
    }

    public String getConfigLongPollTimeout() {
        return this.configLongPollTimeout;
    }

    public void setConfigLongPollTimeout(String string) {
        this.configLongPollTimeout = string;
    }

    public String getConfigRetryTime() {
        return this.configRetryTime;
    }

    public void setConfigRetryTime(String string) {
        this.configRetryTime = string;
    }

    public Boolean getEnableRemoteSyncConfig() {
        return this.enableRemoteSyncConfig;
    }

    public void setEnableRemoteSyncConfig(Boolean bl) {
        this.enableRemoteSyncConfig = bl;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String string) {
        this.endpoint = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String string) {
        this.accessKey = string;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String string) {
        this.secretKey = string;
    }

    public String getRamRoleName() {
        return this.ramRoleName;
    }

    public void setRamRoleName(String string) {
        this.ramRoleName = string;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String string) {
        this.encode = string;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String string) {
        this.clusterName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public List<Config> getSharedConfigs() {
        return this.sharedConfigs;
    }

    public void setSharedConfigs(List<Config> list) {
        this.sharedConfigs = list;
    }

    public List<Config> getExtensionConfigs() {
        return this.extensionConfigs;
    }

    public void setExtensionConfigs(List<Config> list) {
        this.extensionConfigs = list;
    }

    public boolean isRefreshEnabled() {
        return this.refreshEnabled;
    }

    public void setRefreshEnabled(boolean bl) {
        this.refreshEnabled = bl;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="replaced to NacosConfigProperties#sharedConfigs and not use it at the same time.", replacement="spring.cloud.nacos.config.shared-configs[x]")
    public String getSharedDataids() {
        return null == this.getSharedConfigs() ? null : this.getSharedConfigs().stream().map(Config::getDataId).collect(Collectors.joining(COMMAS));
    }

    @Deprecated
    public void setSharedDataids(String string2) {
        if (null != string2 && string2.trim().length() > 0) {
            ArrayList<Config> arrayList = new ArrayList<Config>();
            Stream.of(string2.split(SEPARATOR)).forEach(string -> arrayList.add(new Config(string.trim())));
            this.compatibleSharedConfigs(arrayList);
        }
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="replaced to NacosConfigProperties#sharedConfigs and not use it at the same time.", replacement="spring.cloud.nacos.config.shared-configs[x].refresh")
    public String getRefreshableDataids() {
        return null == this.getSharedConfigs() ? null : this.getSharedConfigs().stream().filter(Config::isRefresh).map(Config::getDataId).collect(Collectors.joining(COMMAS));
    }

    @Deprecated
    public void setRefreshableDataids(String string2) {
        if (null != string2 && string2.trim().length() > 0) {
            ArrayList<Config> arrayList = new ArrayList<Config>();
            Stream.of(string2.split(SEPARATOR)).forEach(string -> arrayList.add(new Config(string.trim()).setRefresh(true)));
            this.compatibleSharedConfigs(arrayList);
        }
    }

    private void compatibleSharedConfigs(List<Config> list) {
        if (null != this.getSharedConfigs()) {
            list.addAll(this.getSharedConfigs());
        }
        ArrayList<Config> arrayList = new ArrayList<Config>();
        list.stream().collect(Collectors.groupingBy(config -> config.getGroup() + config.getDataId(), LinkedHashMap::new, Collectors.toList())).forEach((string, list2) -> list2.stream().reduce((config, config2) -> new Config(config.getDataId(), config.getGroup(), config.isRefresh() || config2 != null && config2.isRefresh())).ifPresent(arrayList::add));
        this.setSharedConfigs(arrayList);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="replaced to NacosConfigProperties#extensionConfigs and not use it at the same time .", replacement="spring.cloud.nacos.config.extension-configs[x]")
    public List<Config> getExtConfig() {
        return this.getExtensionConfigs();
    }

    @Deprecated
    public void setExtConfig(List<Config> list) {
        this.setExtensionConfigs(list);
    }

    @Deprecated
    public ConfigService configServiceInstance() {
        return NacosConfigManager.createConfigService(this);
    }

    @Deprecated
    public Properties getConfigServiceProperties() {
        return this.assembleConfigServiceProperties();
    }

    public Properties assembleConfigServiceProperties() {
        Properties properties = new Properties();
        properties.put("serverAddr", Objects.toString(this.serverAddr, ""));
        properties.put("username", Objects.toString(this.username, ""));
        properties.put("password", Objects.toString(this.password, ""));
        properties.put("encode", Objects.toString(this.encode, ""));
        properties.put("namespace", this.resolveNamespace());
        properties.put("accessKey", Objects.toString(this.accessKey, ""));
        properties.put("secretKey", Objects.toString(this.secretKey, ""));
        properties.put("ramRoleName", Objects.toString(this.ramRoleName, ""));
        properties.put("clusterName", Objects.toString(this.clusterName, ""));
        properties.put("maxRetry", Objects.toString(this.maxRetry, ""));
        properties.put("configLongPollTimeout", Objects.toString(this.configLongPollTimeout, ""));
        properties.put("configRetryTime", Objects.toString(this.configRetryTime, ""));
        properties.put("enableRemoteSyncConfig", Objects.toString(this.enableRemoteSyncConfig, ""));
        String string = Objects.toString(this.endpoint, "");
        if (string.contains(":")) {
            int n = string.indexOf(":");
            properties.put("endpoint", string.substring(0, n));
            properties.put("endpointPort", string.substring(n + 1));
        } else {
            properties.put("endpoint", string);
        }
        this.enrichNacosConfigProperties(properties);
        if (StringUtils.isEmpty((CharSequence)this.serverAddr) && StringUtils.isEmpty((CharSequence)this.endpoint)) {
            properties.put("serverAddr", DEFAULT_ADDRESS);
        }
        return properties;
    }

    private String resolveNamespace() {
        if (DEFAULT_NAMESPACE.equals(this.namespace)) {
            log.info("set nacos config namespace 'public' to ''");
            return "";
        }
        return Objects.toString(this.namespace, "");
    }

    protected void enrichNacosConfigProperties(Properties properties) {
        if (this.environment == null) {
            return;
        }
        Map map = PropertySourcesUtils.getSubProperties((ConfigurableEnvironment)((ConfigurableEnvironment)this.environment), (String)PREFIX);
        map.forEach((string, object) -> properties.putIfAbsent(this.resolveKey((String)string), String.valueOf(object)));
    }

    protected String resolveKey(String string) {
        Matcher matcher = PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        return "NacosConfigProperties{serverAddr='" + this.serverAddr + "', encode='" + this.encode + "', group='" + this.group + "', prefix='" + this.prefix + "', fileExtension='" + this.fileExtension + "', timeout=" + this.timeout + ", maxRetry='" + this.maxRetry + "', configLongPollTimeout='" + this.configLongPollTimeout + "', configRetryTime='" + this.configRetryTime + "', enableRemoteSyncConfig=" + this.enableRemoteSyncConfig + ", endpoint='" + this.endpoint + "', namespace='" + this.namespace + "', accessKey='" + this.accessKey + "', secretKey='" + this.secretKey + "', ramRoleName='" + this.ramRoleName + "', contextPath='" + this.contextPath + "', clusterName='" + this.clusterName + "', name='" + this.name + "'', shares=" + this.sharedConfigs + ", extensions=" + this.extensionConfigs + ", refreshEnabled=" + this.refreshEnabled + "}";
    }

    public static class Config {
        private String dataId;
        private String group = "DEFAULT_GROUP";
        private boolean refresh = false;

        public Config() {
        }

        public Config(String string) {
            this.dataId = string;
        }

        public Config(String string, String string2) {
            this(string);
            this.group = string2;
        }

        public Config(String string, boolean bl) {
            this(string);
            this.refresh = bl;
        }

        public Config(String string, String string2, boolean bl) {
            this(string, string2);
            this.refresh = bl;
        }

        public String getDataId() {
            return this.dataId;
        }

        public Config setDataId(String string) {
            this.dataId = string;
            return this;
        }

        public String getGroup() {
            return this.group;
        }

        public Config setGroup(String string) {
            this.group = string;
            return this;
        }

        public boolean isRefresh() {
            return this.refresh;
        }

        public Config setRefresh(boolean bl) {
            this.refresh = bl;
            return this;
        }

        public String toString() {
            return "Config{dataId='" + this.dataId + "', group='" + this.group + "', refresh=" + this.refresh + "}";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Config config = (Config)object;
            return this.refresh == config.refresh && Objects.equals(this.dataId, config.dataId) && Objects.equals(this.group, config.group);
        }

        public int hashCode() {
            return Objects.hash(this.dataId, this.group, this.refresh);
        }
    }
}

