/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

public class NacosPropertySource
extends MapPropertySource {
    private final String group;
    private final String dataId;
    private final Date timestamp;
    private final boolean isRefreshable;

    NacosPropertySource(String string, String string2, Map<String, Object> map, Date date, boolean bl) {
        super(String.join((CharSequence)",", string2, string), map);
        this.group = string;
        this.dataId = string2;
        this.timestamp = date;
        this.isRefreshable = bl;
    }

    public NacosPropertySource(List<PropertySource<?>> list, String string, String string2, Date date, boolean bl) {
        this(string, string2, NacosPropertySource.getSourceMap(string, string2, list), date, bl);
    }

    private static Map<String, Object> getSourceMap(String string, String string2, List<PropertySource<?>> list) {
        Iterator<PropertySource<?>> iterator;
        LinkedHashMap<String, Object> linkedHashMap;
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        if (list.size() == 1 && (linkedHashMap = list.get(0)) != null && (iterator = linkedHashMap.getSource()) instanceof Map) {
            Map map = (Map)((Object)iterator);
            return map;
        }
        linkedHashMap = new LinkedHashMap<String, Object>();
        ArrayList arrayList = new ArrayList();
        for (PropertySource<?> propertySource : list) {
            if (propertySource == null) continue;
            if (propertySource instanceof MapPropertySource) {
                MapPropertySource mapPropertySource = (MapPropertySource)propertySource;
                Map map = (Map)mapPropertySource.getSource();
                linkedHashMap.putAll(map);
                continue;
            }
            arrayList.add(propertySource);
        }
        if (!arrayList.isEmpty()) {
            linkedHashMap.put(String.join((CharSequence)",", string2, string), arrayList);
        }
        return linkedHashMap;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDataId() {
        return this.dataId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean isRefreshable() {
        return this.isRefreshable;
    }
}

