/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.client;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.parser.NacosDataParserHandler;
import com.alibaba.cloud.nacos.refresh.NacosSnapshotConfigManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertySource;

public class NacosPropertySourceBuilder {
    private static final Logger log = LoggerFactory.getLogger(NacosPropertySourceBuilder.class);
    private ConfigService configService;
    private long timeout;

    public NacosPropertySourceBuilder(ConfigService configService, long l) {
        this.configService = configService;
        this.timeout = l;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    NacosPropertySource build(String string, String string2, String string3, boolean bl) {
        List<PropertySource<?>> list = this.loadNacosData(string, string2, string3);
        NacosPropertySource nacosPropertySource = new NacosPropertySource(list, string2, string, new Date(), bl);
        NacosPropertySourceRepository.collectNacosPropertySource(nacosPropertySource);
        return nacosPropertySource;
    }

    private List<PropertySource<?>> loadNacosData(String string, String string2, String string3) {
        String string4 = null;
        try {
            String string5 = NacosSnapshotConfigManager.getAndRemoveConfigSnapshot(string, string2);
            if (StringUtils.isEmpty((CharSequence)string5)) {
                log.debug("get config from nacos, dataId: {}, group: {}", (Object)string, (Object)string2);
                string4 = this.configService.getConfig(string, string2, this.timeout);
            } else {
                log.debug("get config from memory snapshot, dataId: {}, group: {}", (Object)string, (Object)string2);
                string4 = string5;
            }
            if (StringUtils.isEmpty((CharSequence)string4)) {
                log.warn("Ignore the empty nacos configuration and get it based on dataId[{}] & group[{}]", (Object)string, (Object)string2);
                return Collections.emptyList();
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Loading nacos data, dataId: '%s', group: '%s', data: %s", string, string2, string4));
            }
            return NacosDataParserHandler.getInstance().parseNacosData(string, string4, string3);
        }
        catch (NacosException nacosException) {
            log.error("get data from Nacos error,dataId:{} ", (Object)string, (Object)nacosException);
        }
        catch (Exception exception) {
            log.error("parse data from Nacos error,dataId:{},data:{}", new Object[]{string, string4, exception});
        }
        return Collections.emptyList();
    }
}

